<!DOCTYPE HTML>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,viewport-fit=cover">
  <title>Register - <?php echo $sitename; ?></title>
  <link rel="stylesheet" href="../assets/styles/bootstrap.css">
  <link rel="stylesheet" href="../assets/styles/style.css">
  <link rel="stylesheet" href="../assets/fonts/css/fontawesome-all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600;700&display=swap" rel="stylesheet">

  <style>
    body {
      font-family:'Poppins',sans-serif;
      background:linear-gradient(135deg,#0d47a1,#1976d2);
      min-height:100vh;
      margin:0; padding:0;
    }
    .title-box {
      height:180px;
      background:linear-gradient(135deg,#1976d2,#1565c0);
      border-bottom-left-radius:50% 15%;
      border-bottom-right-radius:50% 15%;
      display:flex;align-items:center;justify-content:center;
    }
    .title-box h1 {color:#fff;font-weight:700;}
    .register-card {
      background:#fff;
      border-radius:1.2rem;
      box-shadow:0 8px 25px rgba(0,0,0,0.15);
      padding:25px;
      margin:-60px 15px 20px;
    }
    .user-top img {
      border-radius:50%;
      box-shadow:0 4px 12px rgba(0,0,0,0.2);
    }
    .form-control {
      border-radius:10px;
      padding:12px 15px;
      font-size:14px;
      border:1px solid #ccc;
    }
    .form-control:focus{
      border-color:#1976d2;
      box-shadow:0 0 0 3px rgba(25,118,210,0.2);
      outline:none;
    }
    .input-style {
      position:relative;
      margin-bottom:18px;
    }
    .input-style i {
      position:absolute;
      top:50%;
      right:15px;
      transform:translateY(-50%);
      color:#1976d2;
      font-size:16px;
      cursor:pointer;
    }
    .btn-action {
      display:block;width:100%;
      background:#1976d2;
      color:#fff;
      border:none;
      border-radius:10px;
      font-weight:600;
      padding:12px;
      font-size:15px;
      transition:.3s;
    }
    .btn-action:hover {background:#0d47a1;}
    .links {margin-top:20px;text-align:center;}
    .links a {
      color:#1976d2;
      text-decoration:none;
      font-size:14px;
    }
    .links a:hover{text-decoration:underline;}
  </style>
</head>
<body>

<div class="title-box">
  <h1><?php echo $sitename; ?></h1>
</div>

<div class="register-card">

  <div class="user-top text-center">
    <img src="../../assets/images/icons/mylogo.png" width="90" height="90">
    <h2 class="mt-3 mb-1 text-primary">REGISTER</h2>
    <p class="text-muted">Create a free account below</p>
  </div>

  <form id="reg-form" method="post" class="mt-3">

    <!-- First Step -->
    <div id="regDiv">
      <div class="input-style">
        <input type="text" class="form-control" id="fname" name="fname" placeholder="First Name" required>
        <i class="fa fa-user"></i>
      </div>
      <div class="input-style">
        <input type="text" class="form-control" id="lname" name="lname" placeholder="Last Name" required>
        <i class="fa fa-user"></i>
      </div>
      <div class="input-style">
        <input type="number" class="form-control" id="phone" name="phone" placeholder="Phone Number" required>
        <i class="fa fa-phone"></i>
      </div>
      <div class="input-style">
        <input type="email" class="form-control" id="email" name="email" placeholder="Email" required>
        <i class="fa fa-at"></i>
      </div>
      <input id="account" name="account" type="hidden" value="1">
      <a id="next-btn" class="btn-action mt-2">Continue</a>
    </div>

    <!-- Second Step -->
    <div id="nextregDiv" style="display:none;">
      <div class="input-style">
        <select class="form-control" id="state" name="state" required>
          <option value="" disabled selected>Select State</option>
          <option value="Abia">Abia</option>
          <option value="Adamawa">Adamawa</option>
          <option value="Akwa Ibom">Akwa Ibom</option>
          <option value="Anambra">Anambra</option>
          <option value="Bauchi">Bauchi</option>
          <option value="Bayelsa">Bayelsa</option>
          <option value="Benue">Benue</option>
          <option value="Borno">Borno</option>
          <option value="Cross River">Cross River</option>
          <option value="Delta">Delta</option>
          <option value="Ebonyi">Ebonyi</option>
          <option value="Edo">Edo</option>
          <option value="Ekiti">Ekiti</option>
          <option value="Enugu">Enugu</option>
          <option value="Gombe">Gombe</option>
          <option value="Imo">Imo</option>
          <option value="Jigawa">Jigawa</option>
          <option value="Kaduna">Kaduna</option>
          <option value="Kano">Kano</option>
          <option value="Katsina">Katsina</option>
          <option value="Kebbi">Kebbi</option>
          <option value="Kogi">Kogi</option>
          <option value="Kwara">Kwara</option>
          <option value="Lagos">Lagos</option>
          <option value="Nasarawa">Nasarawa</option>
          <option value="Niger">Niger</option>
          <option value="Ogun">Ogun</option>
          <option value="Ondo">Ondo</option>
          <option value="Osun">Osun</option>
          <option value="Oyo">Oyo</option>
          <option value="Plateau">Plateau</option>
          <option value="Rivers">Rivers</option>
          <option value="Sokoto">Sokoto</option>
          <option value="Taraba">Taraba</option>
          <option value="Yobe">Yobe</option>
          <option value="Zamfara">Zamfara</option>
          <option value="Abuja FCT">Abuja FCT</option>
        </select>
        <i class="fa fa-map"></i>
      </div>

      <div class="input-style">
        <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
        <i class="fa fa-eye" id="togglePassword"></i>
      </div>

      <div class="input-style">
        <input type="password" class="form-control" id="cpassword" name="cpassword" placeholder="Confirm Password" required>
        <i class="fa fa-eye" id="toggleCPassword"></i>
      </div>

      <div class="input-style">
        <input type="number" class="form-control" id="transpin" name="transpin" placeholder="4 Digit Transaction Pin" required>
        <i class="fa fa-key"></i>
      </div>

      <div class="input-style">
        <input type="text" class="form-control" id="referal" name="referal" placeholder="Referral Code (optional)">
        <i class="fa fa-user-plus"></i>
      </div>

      <button type="submit" id="submit-btn" class="btn-action mt-2">Register</button>
    </div>
  </form>

  <div class="links mt-3">
    <p><a href="../login/">Already have an account? Login Now</a></p>
  </div>

</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

<script>
$(function(){
  // Enable readonly fields to be typed when clicked
  $("#email,#phone,#password,#cpassword").on("click",function(){
    $(this).removeAttr("readonly");
  });

  // Auto-fill referral code from URL if present
  const urlParams = new URLSearchParams(window.location.search);
  const refCode = urlParams.get('ref');
  if(refCode){
    $('#referal').val(refCode);
  }

  // Next Step
  $("#next-btn").click(function(){
    let msg = "";
    if($("#fname").val() === "" || $("#lname").val() === "" || $("#phone").val() === "" || $("#email").val() === ""){
      msg = "Please fill all required fields.";
    }
    if(msg !== ""){
      swal("Alert!!", msg, "info");
      return;
    }
    $("#regDiv").hide();
    $("#nextregDiv").show();
  });

  // Submit Registration
  $('#reg-form').submit(function(e){
    e.preventDefault();
    let msg = "";
    if($("#password").val().length < 8){
      msg = "Password must be at least 8 characters.";
    }
    if($("#password").val() !== $("#cpassword").val()){
      msg = "Passwords do not match.";
    }
    if($("#transpin").val().length !== 4){
      msg = "Transaction pin must be 4 digits.";
    }
    if(msg !== ""){
      swal("Alert!!", msg, "info");
      return;
    }

    $('#submit-btn').html('<i class="fa fa-spinner fa-spin"></i> Processing...');

    $.ajax({
      url: '../home/includes/route.php?register',
      data: new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      method: 'POST',
      success: function(resp){
        resp = JSON.parse(resp);
        if(resp.status === "success"){
          swal("Success", "Registration Successful", "success");
          setTimeout(() => { location.replace("../home/"); }, 1000);
        } else {
          swal("Error", resp.msg, "error");
          $("#nextregDiv").hide();
          $("#regDiv").show();
        }
        $('#submit-btn').html('Register');
      }
    });
  });

  // Toggle password visibility
  $('#togglePassword').on('click', function(){
    const input = $('#password');
    const type = input.attr('type') === 'password' ? 'text' : 'password';
    input.attr('type', type);
    $(this).toggleClass('fa-eye fa-eye-slash');
  });

  $('#toggleCPassword').on('click', function(){
    const input = $('#cpassword');
    const type = input.attr('type') === 'password' ? 'text' : 'password';
    input.attr('type', type);
    $(this).toggleClass('fa-eye fa-eye-slash');
  });
});
</script>

</body>
</html>
