<!DOCTYPE HTML>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
  <meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,viewport-fit=cover">
  <title><?php echo $sitename; ?> - Login</title>
  <link rel="manifest" href="../mobile/manifest.json">
  <meta name="theme-color" content="#1976d2">

  <!-- Bootstrap css -->
  <link rel="stylesheet" href="../assets/styles/bootstrap.css">
  <link rel="stylesheet" href="../assets/styles/style.css">
  <link rel="stylesheet" href="../assets/fonts/css/fontawesome-all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600;700&display=swap" rel="stylesheet">

  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg,#0d47a1,#1976d2);
      min-height: 100vh;
    }
    .title-box-container {
      height: 180px;
      background: linear-gradient(135deg,#1976d2,#1565c0);
      border-bottom-left-radius: 50% 15%;
      border-bottom-right-radius: 50% 15%;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .title-box-container h1 {
      color: #fff;
      font-weight: 700;
    }
    .login-card {
      background: #fff;
      border-radius: 1.2rem;
      box-shadow: 0 8px 25px rgba(0,0,0,0.15);
      padding: 30px;
      margin: -60px 15px 20px;
    }
    .user-top img {
      border-radius: 50%;
      box-shadow: 0px 4px 15px rgba(0,0,0,0.2);
    }
    .form-control {
      border-radius: 10px;
      padding: 12px 40px 12px 15px;
      border: 1px solid #ddd;
      transition: all 0.3s ease;
    }
    .form-control:focus {
      border-color: #1976d2;
      box-shadow: 0 0 0 3px rgba(25,118,210,0.2);
    }
    .input-style {
      position: relative;
      margin-bottom: 20px;
    }
    .input-style i {
      position: absolute;
      top: 50%;
      right: 15px;
      transform: translateY(-50%);
      color: #1976d2;
      font-size: 16px;
      cursor: pointer;
    }
    .btn-login {
      width: 100%;
      background: #1976d2;
      border: none;
      border-radius: 10px;
      color: #fff;
      font-weight: 600;
      padding: 12px;
      font-size: 16px;
      transition: all .3s;
    }
    .btn-login:hover {
      background: #0d47a1;
    }
    .links a {
      font-size: 14px;
      color: #1976d2;
      text-decoration: none;
    }
    .links a:hover {
      text-decoration: underline;
    }
  </style>
</head>

<body>
<div id="page" class="d-flex align-items-center justify-content-center flex-column">

  <!-- Header Brand -->
  <div class="title-box-container w-100">
    <h1><?php echo $sitename; ?></h1>
  </div>

  <!-- Login Card -->
  <div class="login-card w-100">

    <div class="user-top text-center">
      <img src="../../assets/images/icons/mylogo.png" alt="logo" width="90" height="90">
      <h2 class="mt-3 mb-1 text-primary">LOGIN</h2>
      <p class="text-muted">Welcome to <?php echo $sitename; ?></p>
    </div>

    <!-- Option to switch number -->
    <div id="switch-number" class="text-center mb-3" style="display:none;">
      <a href="#" id="changeNumber">Login with another number</a>
    </div>

    <form id="login-form" method="post" class="mt-3">
      <div class="input-style" id="phoneBlock">
        <input type="number" class="form-control" id="phonelogin" name="phone" placeholder="Phone Number" required>
        <i class="fa fa-phone"></i>
      </div>
      <div class="input-style">
        <input type="password" class="form-control" id="passwordlogin" name="password" placeholder="Password" required>
        <i class="fa fa-eye" id="togglePassword"></i>
      </div>
      <input type="hidden" id="deviceid" name="device" value="1723476891xlrsFkvJDq963">
      <button type="submit" id="submit-btn" class="btn-login mt-2">Login</button>
    </form>

    <div class="links text-center mt-3">
      <p><a href="../recovery/">Forgot Password?</a></p>
      <p><a href="../register/">New User? Create Account</a></p>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

<script>
  $(function(){
    let savedPhone = localStorage.getItem("userPhone");

    if(savedPhone){
        $("#phonelogin").val(savedPhone);
        $("#phoneBlock").hide();
        $("#switch-number").show();
    }

    $("#changeNumber").click(function(e){
        e.preventDefault();
        localStorage.removeItem("userPhone");
        $("#phonelogin").val("");
        $("#phoneBlock").show();
        $("#switch-number").hide();
    });

    $('#login-form').submit(function(e){
      e.preventDefault();
      $('#submit-btn').html('<i class="fa fa-spinner fa-spin"></i> Processing ...');
      $.ajax({
        url: '../home/includes/route.php?login',
        data: new FormData(this),
        processData:false, contentType:false, method:'POST',
        success:function(resp){
          resp = JSON.parse(resp);
          if(resp.status=="success"){
             if(!savedPhone){
                let phone = $("#phonelogin").val();
                localStorage.setItem("userPhone", phone);
             }
             swal('Success',"Login Successful","success");
             setTimeout(()=> location.replace('../home/'),1000);
          }else{
             swal('Error',resp.msg,"error");
          }
          $('#submit-btn').html('Login');
        }
      })
    });

    // Toggle password visibility
    $('#togglePassword').on('click', function(){
      const input = $('#passwordlogin');
      const type = input.attr('type') === 'password' ? 'text' : 'password';
      input.attr('type', type);
      $(this).toggleClass('fa-eye fa-eye-slash');
    });
  });
</script>
</body>
</html>
