<!DOCTYPE html>
<html lang="en">
        <!-- Page content start here-->
        <div class="page-content header-clear-medium">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1.0"/>
  <title>Transactions - <?php echo $sitename; ?></title>

  <!-- Icons & CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
  <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>
  <link rel="stylesheet" href="../assets/styles/bootstrap.css">

  <style>
    body{font-family:'Poppins',sans-serif;background:#f4f9ff;padding-bottom:70px;}

    .header-transactions{
      background:linear-gradient(135deg,#0d47a1,#1976d2);
      color:#fff;text-align:center;
      padding:30px 20px;border-bottom-left-radius:25px;border-bottom-right-radius:25px;
      box-shadow:0 4px 12px rgba(0,0,0,0.2);
    }
    .header-transactions h1{font-size:22px;margin:0;font-weight:600;}
    .header-transactions p{font-size:13px;opacity:0.9;}

    .search-card{
      background:#fff;margin:15px;border-radius:15px;padding:15px;
      box-shadow:0 4px 12px rgba(0,0,0,0.08);
    }
    .search-card h4{margin-bottom:10px;color:#0d47a1;}
    .search-card .form-control{
      border-radius:8px;font-size:14px;
    }
    .search-card button{
      border-radius:8px;padding:8px 15px;
    }

    .transactions-list{
      background:#fff;margin:15px;padding:15px;border-radius:15px;
      box-shadow:0 4px 12px rgba(0,0,0,0.08);
    }
    .transaction-item{
      display:flex;align-items:center;margin-bottom:15px;
    }
    .transaction-icon{
      width:36px;height:36px;border-radius:50%;
      display:flex;justify-content:center;align-items:center;
      color:#fff;font-size:14px;
    }
    .transaction-details{flex:1;margin-left:12px;}
    .transaction-details h5{margin:0;font-size:15px;}
    .transaction-details small{font-size:12px;color:#777;}
    .transaction-amount{text-align:right;}
    .transaction-amount h5{margin:0;font-size:15px;font-weight:700;}
    .transaction-amount span{font-size:11px;}

    /* Status colors */
    .status-success{color:#28a745;}
    .status-pending{color:#007bff;}
    .status-failed{color:#dc3545;}

    /* Footer like other pages */
    .footer-bar-6-modern {
      position: fixed;bottom:0;left:0;right:0;height:60px;
      background:#fff;display:flex;justify-content:space-around;align-items:center;
      border-top:1px solid #e0e0e0;box-shadow:0 -2px 10px rgba(0,0,0,.08);
      z-index:9999;
    }
    .footer-bar-6-modern a{
      flex:1;text-align:center;text-decoration:none;color:#555;font-size:11px;
    }
    .footer-bar-6-modern .icon-wrap{
      width:28px;height:28px;background:#f5f7fa;border-radius:50%;
      display:flex;align-items:center;justify-content:center;
      margin:0 auto 3px;transition:.3s;
    }
    .footer-bar-6-modern .icon-wrap i,
    .footer-bar-6-modern .icon-wrap ion-icon{font-size:16px;color:#1976d2;}
    .footer-bar-6-modern a span{display:block;font-size:11px;}
    .footer-bar-6-modern a.active .icon-wrap,
    .footer-bar-6-modern a:hover .icon-wrap{background:#1976d2;}
    .footer-bar-6-modern a.active .icon-wrap i,
    .footer-bar-6-modern a.active .icon-wrap ion-icon,
    .footer-bar-6-modern a:hover .icon-wrap i,
    .footer-bar-6-modern a:hover .icon-wrap ion-icon{color:#fff;}
  </style>
</head>
<body>

  <!-- Header -->
  <div class="header-transactions">
    <h1>Transactions</h1>
    <p>Your last 100 transactions<br/><small>Click on a transaction to view details</small></p>
  </div>

  <!-- Search Form -->
  <div class="search-card">
    <form method="GET" class="the-submit-form">
      <div class="form-group mb-2">
        <input type="text" class="form-control" placeholder="Keyword (Phone or Ref...)" name="search">
      </div>
      <div class="form-group mb-2">
        <select class="form-control" name="searchfor" required>
          <option value="">Search For ..</option>
          <option value="all">All Transactions</option>
          <option value="reference">Reference</option>
          <option value="wallet">Wallet</option>
          <option value="monnify">Monnify</option>
          <option value="paystack">Paystack</option>
          <option value="airtime">Airtime</option>
          <option value="data">Data</option>
          <option value="cable">Cable TV</option>
          <option value="exam">Exam Pin</option>
          <option value="electricity">Electricity</option>
        </select>
      </div>
      <button class="btn btn-primary w-100" type="submit"><i class="fa fa-search"></i> Search</button>
    </form>
    <?php if(isset($_GET["search"])): ?>
      <p class="mt-2 text-info"><b>Showing Result For: '<?php echo $_GET["search"]; ?>'</b></p>
    <?php endif; ?>
  </div>

  <!-- Transactions List -->
  <div class="transactions-list">
    <?php if(!empty($data)){ $i=1; foreach($data as $list){ ?>
      <a href="transaction-details?ref=<?php echo $list->transref; ?>" class="transaction-item text-decoration-none text-dark">
        
        <!-- Icon -->
        <?php if($list->servicename=="Airtime"): ?>
          <div class="transaction-icon" style="background:#28a745"><i class="fa fa-phone"></i></div>
        <?php elseif($list->servicename=="Data"): ?>
          <div class="transaction-icon" style="background:#007bff"><i class="fa fa-wifi"></i></div>
        <?php elseif($list->servicename=="Cable TV"): ?>
          <div class="transaction-icon" style="background:#795548"><i class="fa fa-tv"></i></div>
        <?php elseif($list->servicename=="Electricity Bill"): ?>
          <div class="transaction-icon" style="background:#ffc107"><i class="fa fa-bolt"></i></div>
        <?php elseif($list->servicename=="Exam Pin"): ?>
          <div class="transaction-icon" style="background:#17a2b8"><i class="fa fa-graduation-cap"></i></div>
        <?php elseif($list->servicename=="Wallet Transfer"): ?>
          <div class="transaction-icon" style="background:#e83e8c"><i class="fa fa-arrow-up"></i></div>
        <?php elseif($list->servicename=="Referral Bonus"): ?>
          <div class="transaction-icon" style="background:#6f42c1"><i class="fa fa-user"></i></div>
        <?php elseif($list->servicename=="Virtual Card"): ?>
          <div class="transaction-icon" style="background:#007bff"><i class="fa fa-credit-card"></i></div>
        <?php else: ?>
          <div class="transaction-icon" style="background:#6c757d"><i class="fa fa-list"></i></div>
        <?php endif; ?>

        <!-- Details -->
        <div class="transaction-details">
          <h5><?php echo $list->servicename; ?></h5>
          <small><?php echo $list->servicedesc; ?> | Ref: <?php echo $list->transref; ?></small>
        </div>

        <!-- Amount and Status -->
        <div class="transaction-amount">
          <?php if($list->servicename=="Virtual Card"): ?>
            <h5>$<?php echo $list->amount; ?></h5>
          <?php else: ?>
            <h5>₦<?php echo $list->amount; ?></h5>
          <?php endif; ?>
          
          <?php if($list->status==0): ?>
            <span class="status-success"><?php echo $controller->formatDate2($list->date); ?> ✔</span>
          <?php elseif($list->status==5 || $list->status==2): ?>
            <span class="status-pending"><?php echo $controller->formatDate2($list->date); ?> ⏳</span>
          <?php else: ?>
            <span class="status-failed"><?php echo $controller->formatDate2($list->date); ?> ✘</span>
          <?php endif; ?>
        </div>
      </a>
      <hr/>
    <?php $i++; }} else { echo "<h3 class='text-danger'>No Transaction To Display</h3>";} ?>
  </div>

  <!-- Next 100 btn -->
  <div class="search-card">
    <div class="d-flex justify-content-between align-items-center">
      <h5>Transactions</h5>
      <a class="btn btn-sm btn-primary" href="transactions?page=<?php echo $pageCount; if(isset($_GET['search'])) echo '&search='.$_GET['search'].'&searchfor='.$_GET['searchfor']; ?>">Next 100</a>
    </div>
  </div>

  <!-- Footer -->
  <div id="footer-bar" class="footer-bar-6-modern">
    <a href="homepage"><div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div><span>Home</span></a>
    <a href="profile"><div class="icon-wrap"><i class="fa fa-user"></i></div><span>Profile</span></a>
    <a href="contact-us"><div class="icon-wrap"><i class="fa fa-headset"></i></div><span>Support</span></a>
    <a href="transactions" class="active"><div class="icon-wrap"><i class="fa fa-clock-rotate-left"></i></div><span>History</span></a>
    <a href="more-services"><div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div><span>More</span></a>
  </div>

</body>
</html>