<div class="page-content header-clear-medium">

 <!-- Sticky Header -->
<div class="page-header text-center text-white py-3 mb-3">
  <h5 class="mb-0">Transaction Receipt</h5>
</div>

<div class="card card-style shadow-sm">
  <div class="content">

    <div id="receipt-area">
      <div class="text-center mb-2">
        <img src="../../assets/images/icons/success.png" style="width:50px; height:50px;" />
      </div>
      <p class="mb-0 fw-bold text-dark text-center">Transaction Details</p>
      <h3 class="text-center"><?php echo $controller->formatStatus($data->status); ?></h3>
      <hr/>
      <table class="table table-bordered">
        <tr>
          <td><b>Ref No:</b></td>
          <td align="right"><?php echo $data->transref; ?></td>
        </tr>
        <tr>
          <td><b>Date:</b></td>
          <td align="right"><?php echo $controller->formatDate($data->date); ?></td>
        </tr>
        <tr>
          <td><b>Service:</b></td>
          <td align="right"><?php echo $data->servicename; ?></td>
        </tr>
        <tr>
          <td><b>Description:</b></td>
          <td align="right"><?php echo $data->servicedesc; ?></td>
        </tr>
        <?php if(!isset($_GET["receipt"])): ?>
        <tr>
          <td><b>Amount:</b></td>
          <td align="right">N<?php echo $data->amount; ?></td>
        </tr>
        <tr>
          <td><b>Old Balance:</b></td>
          <td align="right">N<?php echo $data->oldbal; ?></td>
        </tr>
        <tr>
          <td><b>New Balance:</b></td>
          <td align="right">N<?php echo $data->newbal; ?></td>
        </tr>
        <?php endif; ?>
      </table>
    </div>

    <!-- Help Codes -->
    <div data-menu="helpcode-box" class="input-style py-2 px-3 bg-light border rounded d-flex justify-content-between align-items-center mb-3">
      <div>
        <p class="text-primary mb-0"><i class="fa fa-phone-book"></i> <b id="mycontactname">View Help Codes</b></p>
        <small class="text-muted">Help Codes To Check Your Balance</small>
      </div>
      <i class="fa fa-info-circle text-primary"></i>
    </div>

    <!-- Action Buttons -->
    <div class="text-center mt-3">
      <?php if(!isset($_GET["receipt"])): ?>
      <a href="transaction-details?receipt&ref=<?php echo $_GET["ref"]; ?>" class="btn btn-success btn-sm mb-2">
        <b>View User Receipt</b>
      </a>
      <?php endif; ?>
      <button onclick="downloadReceipt()" class="btn btn-primary btn-sm mb-2">
        <b>Download as Image</b>
      </button>
      <button onclick="shareReceipt()" class="btn btn-info btn-sm mb-2">
        <b>Share Receipt</b>
      </button>
      <?php if($data->servicename == "Recharge Pin" && $data->status == 0): ?>
      <a href="view-recharge-pins?ref=<?php echo $_GET["ref"]; ?>" class="btn btn-primary btn-sm mb-2">
        <b>View Pins</b>
      </a>
      <?php endif; ?>
      <?php
      if($data->servicename == "ID Verification"){
          $conn = mysqli_connect("localhost","specials_Portal","w^WqB]8]ymoG","specials_Portal");   
          $report  = $_GET["ref"];
          $pdf = "";
          $check = mysqli_query($conn, "SELECT * FROM reports WHERE transid = '$report'");
          if(mysqli_num_rows($check) == 1){
              $report = mysqli_fetch_assoc($check);
              $pdf = $report["pdf"];    
          }
      }   
      ?>
      <?php if($data->servicename == "ID Verification"): ?>
      <a href="<?php echo $pdf; ?>" class="btn btn-primary btn-sm mb-2">
        <b>Download Slip</b>
      </a>
      <?php endif; ?>
      <?php if($data->servicename == "Data Pin" && $data->status == 0): ?>
      <a href="view-pins?ref=<?php echo $_GET["ref"]; ?>" class="btn btn-primary btn-sm mb-2">
        <b>View Pins</b>
      </a>
      <?php endif; ?>
      <button class="btn btn-danger btn-sm mb-2" id="issuebtn" onclick="$('#issuebtn').removeClass('btn-warning'); $('#issuebtn').addClass('btn-secondary'); $('#issuebtn').html('<i class=\'fa fa-spinner fa-spin\'></i> Submitting...'); $('#issueForm').submit();">
        <b>Report</b>
      </button>
    </div>
  </div>
</div>

<!-- Help Codes Modal -->
<div id="helpcode-box" class="menu menu-box-bottom rounded-l" data-menu-effect="menu-over" style="display: block; height: 90vh; background:#fff;">
  <div class="menu-title">
    <h1 class="font-24 mb-0 pb-0">Help Codes</h1>
    <a href="#" class="close-menu font-25"><i class="fa fa-times-circle"></i></a>
  </div>
  <hr />
  <div class="mb-0 mt-0 row">
    <!-- Help codes content -->
  </div>
</div>

<!-- Footer -->
<div id="footer-bar" class="footer-bar-6-modern">
  <a href="homepage">
    <div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div>
    <span>Home</span>
  </a>
  <a href="profile">
    <div class="icon-wrap"><i class="fa fa-user"></i></div>
    <span>Profile</span>
  </a>
  <a href="contact-us">
    <div class="icon-wrap"><i class="fa fa-headset"></i></div>
    <span>Support</span>
  </a>
  <a href="transactions">
    <div class="icon-wrap"><i class="fa-solid fa-clock-rotate-left"></i></div>
    <span>History</span>
  </a>
  <a href="more-services">
    <div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div>
    <span>More</span>
  </a>
</div>

<!-- Scripts -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
function downloadReceipt() {
  html2canvas(document.getElementById('receipt-area')).then(function(canvas) {
    var link = document.createElement('a');
    link.download = 'transaction-receipt.png';
    link.href = canvas.toDataURL();
    link.click();
  });
}
function shareReceipt() {
  html2canvas(document.getElementById('receipt-area')).then(function(canvas) {
    canvas.toBlob(function(blob) {
      if (navigator.canShare && navigator.canShare({ files: [new File([blob], 'receipt.png', {type: blob.type})] })) {
        const file = new File([blob], 'receipt.png', {type: blob.type});
        navigator.share({
          files: [file],
          title: 'Transaction Receipt',
          text: 'See my transaction receipt'
        });
      } else {
        alert('Sharing not supported on this device/browser. You can download the image instead.');
      }
    });
  });
}
</script>

<!-- Modern CSS -->
<style>
.page-header {
  background: linear-gradient(135deg,#0d47a1,#1976d2) !important;
  border-bottom-left-radius: 20px;
  border-bottom-right-radius: 20px;
  position: sticky;
  top: 0;
  z-index: 1000;
  padding: 15px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}
.page-header h5 {
  margin: 0;
  font-weight: 700;
  letter-spacing: 0.5px;
}
.card.card-style {
  border-radius: 15px;
  box-shadow: 0 6px 20px rgba(0,0,0,0.08);
  border: none;
  overflow: hidden;
}
#receipt-area table {
  width: 100%;
  background: #fff;
  border-radius: 10px;
  overflow: hidden;
  table-layout: fixed; /* important for wrapping */
  word-wrap: break-word;
}

#receipt-area table td {
  padding: 10px 12px;
  font-size: 14px;
  vertical-align: top;
  word-break: break-word;
  max-width: 100%;
  white-space: normal;
}

#receipt-area table tr:nth-child(even) td {
  background: #f5f8fc;
}

@media (max-width: 576px) {
  #receipt-area {
    overflow-x: auto;
  }
}


/* Help Codes box */
.input-style.bg-light {
  border: 1px solid #e0e6ef !important;
  background: #f5f8fc !important;
  border-radius: 10px !important;
  transition: background 0.3s ease;
}
.input-style.bg-light:hover {
  background: #eef3fa !important;
}

/* Action buttons */
.text-center.mt-3 .btn {
  border-radius: 30px !important;
  padding: 8px 16px;
  font-weight: 600;
  font-size: 13px;
  box-shadow: 0 3px 8px rgba(0,0,0,0.08);
  transition: transform 0.2s ease, box-shadow 0.2s ease;
}
.text-center.mt-3 .btn:hover {
  transform: translateY(-1px);
  box-shadow: 0 4px 12px rgba(0,0,0,0.12);
}

.btn-success { background-color: #28a745 !important; border: none; }
.btn-primary { background-color: #1976d2 !important; border: none; }
.btn-info    { background-color: #17a2b8 !important; border: none; }
.btn-danger  { background-color: #dc3545 !important; border: none; }

/* Help Codes modal */
#helpcode-box {
  border-top-left-radius: 20px;
  border-top-right-radius: 20px;
  box-shadow: 0 -4px 20px rgba(0,0,0,0.1);
}
#helpcode-box .menu-title {
  background: linear-gradient(135deg,#0d47a1,#1976d2);
  color: #fff;
  padding: 15px;
  border-top-left-radius: 20px;
  border-top-right-radius: 20px;
}
#helpcode-box h1 {
  font-weight: 700;
}

/* Footer bar */
.footer-bar-6-modern {
  position: fixed; bottom:0; left:0; right:0;
  height:60px;
  background:#fff;
  display:flex; justify-content:space-around; align-items:center;
  border-top:1px solid #e0e0e0;
  box-shadow:0 -2px 10px rgba(0,0,0,.08);
  z-index:9999;
}
.footer-bar-6-modern a {
  flex:1; text-align:center; text-decoration:none; color:#555; font-size:11px;
}
.footer-bar-6-modern a span {
  display:block; font-size:11px; margin-top:2px;
}
.icon-wrap {
  width:28px; height:28px; border-radius:50%;
  background:#f5f7fa;
  display:flex; align-items:center; justify-content:center;
  margin:0 auto 3px; transition:.3s;
}
.icon-wrap i, .icon-wrap ion-icon {
  font-size:16px; color:#1976d2; transition:.2s;
}
.footer-bar-6-modern a.active .icon-wrap,
.footer-bar-6-modern a:hover .icon-wrap {background:#1976d2;}
.footer-bar-6-modern a.active .icon-wrap i,
.footer-bar-6-modern a.active .icon-wrap ion-icon,
.footer-bar-6-modern a:hover .icon-wrap i,
.footer-bar-6-modern a:hover .icon-wrap ion-icon {color:#fff;}
</style>
