<!DOCTYPE html>
<html lang="en">
        <!-- Page content start here-->
        <div class="page-content header-clear-medium">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1.0" />
  <title><?php echo $sitename; ?> - Profile</title>
  
  <!-- Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
  <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>

  <link rel="stylesheet" href="../assets/styles/bootstrap.css">

  <style>
    body{
      font-family:'Poppins',sans-serif;background:#f9fbfd;
      padding-bottom:70px;
    }
    .profile-header{
      background:linear-gradient(135deg,#0d47a1,#1976d2);
      color:#fff;text-align:center;
      padding:40px 20px;border-bottom-left-radius:30px;border-bottom-right-radius:30px;
      box-shadow:0 4px 15px rgba(0,0,0,0.25);
    }
    .profile-header img{
      width:90px;height:90px;border-radius:50%;
      border:3px solid #fff;box-shadow:0 3px 12px rgba(0,0,0,0.3);
      margin-bottom:10px;
    }
    .profile-header h1{font-size:20px;margin-bottom:0;}
    .accordion .card{
      border:none;border-radius:12px;margin:10px 0;
      box-shadow:0 4px 12px rgba(0,0,0,0.08);
    }
    .accordion-btn{
      width:100%;text-align:left;border:none;
      padding:15px;font-weight:600;
      color:#0d47a1;font-size:15px;display:flex;
      align-items:center;justify-content:space-between;
      background:#fff;border-radius:12px;
    }
    .accordion-btn i:first-child{ color:#1976d2;margin-right:8px;}
    .accordion .collapse .list-group a{
      display:flex;align-items:center;justify-content:space-between;
      padding:10px;color:#333;text-decoration:none;
      border-bottom:1px solid #eee;
    }
    .accordion .collapse .list-group a i{color:#1976d2;}
    .accordion .collapse .list-group a:last-child{border:none;}
    .btn-info{
      background:#1976d2 !important;border:none;border-radius:10px;
    }
    /* Footer Matching */
    .footer-bar-6-modern {
      position: fixed;bottom:0;left:0;right:0;height:60px;
      background:#fff;display:flex;justify-content:space-around;align-items:center;
      border-top:1px solid #e0e0e0;box-shadow:0 -2px 10px rgba(0,0,0,.08);
      z-index:9999;
    }
    .footer-bar-6-modern a{
      flex:1;text-align:center;text-decoration:none;color:#555;font-size:11px;
    }
    .footer-bar-6-modern .icon-wrap{
      width:28px;height:28px;background:#f5f7fa;border-radius:50%;
      display:flex;align-items:center;justify-content:center;
      margin:0 auto 3px;transition:.3s;
    }
    .footer-bar-6-modern .icon-wrap i,
    .footer-bar-6-modern .icon-wrap ion-icon{font-size:16px;color:#1976d2;}
    .footer-bar-6-modern a span{display:block;font-size:11px;}
    .footer-bar-6-modern a.active .icon-wrap,
    .footer-bar-6-modern a:hover .icon-wrap{background:#1976d2;}
    .footer-bar-6-modern a.active .icon-wrap i,
    .footer-bar-6-modern a.active .icon-wrap ion-icon,
    .footer-bar-6-modern a:hover .icon-wrap i,
    .footer-bar-6-modern a:hover .icon-wrap ion-icon{color:#fff;}
  </style>
</head>
<body>

  <!-- Profile Header -->
  <div class="profile-header">
    <img src="../../assets/images/icons/mylogo.png" alt="profile">
    <h1><?php echo $profileDetails->sFname; ?> <small>(<?php echo $controller->formatUserType($profileDetails->sType); ?>)</small></h1>
  </div>

  <!-- Accordion Sections -->
  <div class="page-content header-clear-medium p-3">
    <div class="accordion" id="accordionProfile">

      <!-- Personal Info -->
      <div class="card">
        <button class="btn accordion-btn" data-bs-toggle="collapse" data-bs-target="#collapseInfo">
          <i class="fa fa-user"></i> Personal Information <i class="fa fa-chevron-down"></i>
        </button>
        <div id="collapseInfo" class="collapse" data-bs-parent="#accordionProfile">
          <div class="list-group">
            <a href="#"><span><b>Name:</b> <?php echo $data->sFname." ".$data->sLname; ?></span></a>
            <a href="#"><span><b>Email:</b> <?php echo $data->sEmail; ?></span></a>
            <a href="#"><span><b>Phone:</b> <?php echo $data->sPhone; ?></span></a>
            <a href="#"><span><b>State:</b> <?php echo $data->sState; ?></span></a>
            <a href="#"><span><b>Account Limit:</b> ₦<?php echo $data->sAccountLimit; ?></span></a>
            <a href="#"><span><b>KYC Status:</b> No</span></a>
          </div>
        </div>
      </div>

      <!-- Referral -->
      <div class="card">
        <a class="btn accordion-btn" href="referrals">
          <i class="fa fa-users"></i> Referral Link <i class="fa fa-link"></i>
        </a>
      </div>

      <!-- Update Password -->
      <div class="card">
        <button class="btn accordion-btn" data-bs-toggle="collapse" data-bs-target="#collapsePass">
          <i class="fa fa-lock"></i> Update Password <i class="fa fa-chevron-down"></i>
        </button>
        <div id="collapsePass" class="collapse">
          <div class="p-3 bg-white">
            <form id="passForm" method="post">
              <input type="password" class="form-control mb-2" name="oldpass" placeholder="Old Password">
              <input type="password" class="form-control mb-2" name="newpass" placeholder="New Password">
              <input type="password" class="form-control mb-2" placeholder="Retype Password">
              <button type="submit" class="btn btn-info w-100">Update Password</button>
            </form>
          </div>
        </div>
      </div>

      <!-- Update Pin -->
      <div class="card">
        <button class="btn accordion-btn" data-bs-toggle="collapse" data-bs-target="#collapsePin">
          <i class="fa fa-key"></i> Update Transaction Pin <i class="fa fa-chevron-down"></i>
        </button>
        <div id="collapsePin" class="collapse">
          <div class="p-3 bg-white">
            <form id="pinForm" method="post">
              <input type="number" class="form-control mb-2" name="vcode" placeholder="Access Code">
              <input type="number" class="form-control mb-2" name="newpin" placeholder="New Pin">
              <input type="number" class="form-control mb-2" placeholder="Retype Pin">
              <button type="submit" class="btn btn-info w-100">Update Pin</button>
            </form>
          </div>
        </div>
      </div>

      <!-- Contact & Logout -->
      <div class="card">
        <a class="btn accordion-btn" href="contact-us">
          <i class="fa fa-headset"></i> Contact Support <i class="fa fa-chevron-right"></i>
        </a>
      </div>
      <div class="card">
        <a class="btn accordion-btn text-danger" href="logout">
          <i class="fa fa-power-off"></i> Logout <i class="fa fa-chevron-right"></i>
        </a>
      </div>
    </div>
  </div>

  <!-- Footer -->
  <div id="footer-bar" class="footer-bar-6-modern">
    <a href="homepage">
      <div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div><span>Home</span>
    </a>
    <a href="profile" class="active">
      <div class="icon-wrap"><i class="fa fa-user"></i></div><span>Profile</span>
    </a>
    <a href="contact-us">
      <div class="icon-wrap"><i class="fa fa-headset"></i></div><span>Support</span>
    </a>
    <a href="transactions">
      <div class="icon-wrap"><i class="fa fa-clock-rotate-left"></i></div><span>History</span>
    </a>
    <a href="more-services">
      <div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div><span>More</span>
    </a>
  </div>

  <script src="../assets/scripts/bootstrap.min.js"></script>
</body>
</html>