<!DOCTYPE html>
<html lang="en">
       <!-- Page content start here-->
   <div class="page-content header-clear">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1.0"/>
  <title>More Services - <?php echo $sitename; ?></title>

  <!-- Icons & Bootstrap -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
  <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>
  <link rel="stylesheet" href="../assets/styles/bootstrap.css">

  <style>
    body{font-family:'Poppins',sans-serif;background:#f4f9ff;padding-bottom:70px;}
    .more-header{
      background:linear-gradient(135deg,#0d47a1,#1976d2);
      color:#fff;text-align:center;
      padding:30px 20px;border-bottom-left-radius:25px;border-bottom-right-radius:25px;
      box-shadow:0 4px 12px rgba(0,0,0,0.2);
    }
    .more-header h1{font-size:22px;margin:0;font-weight:600;}

    .service-card{
      background:#fff;margin:15px;border-radius:15px;
      box-shadow:0 4px 12px rgba(0,0,0,0.08);
      padding:15px;
    }
    .service-grid{
      display:grid;
      grid-template-columns:repeat(4,1fr);
      gap:15px;
      text-align:center;
    }
    .service-grid a{
      display:flex;flex-direction:column;
      align-items:center;justify-content:center;
      padding:12px;border-radius:12px;
      background:#f8f9fa;text-decoration:none;
      color:#333;font-size:12px;font-weight:500;
      transition:.25s;
    }
    .service-grid a:hover{background:#e9f2ff;transform:translateY(-3px);}
    .service-grid i{font-size:20px;margin-bottom:6px;color:#1976d2;}

    .footer-bar-6-modern {
      position: fixed;bottom:0;left:0;right:0;height:60px;
      background:#fff;display:flex;justify-content:space-around;align-items:center;
      border-top:1px solid #e0e0e0;box-shadow:0 -2px 10px rgba(0,0,0,.08);
      z-index:9999;
    }
    .footer-bar-6-modern a{
      flex:1;text-align:center;text-decoration:none;color:#555;font-size:11px;
    }
    .footer-bar-6-modern .icon-wrap{
      width:28px;height:28px;background:#f5f7fa;border-radius:50%;
      display:flex;align-items:center;justify-content:center;
      margin:0 auto 3px;transition:.3s;
    }
    .footer-bar-6-modern .icon-wrap i,
    .footer-bar-6-modern .icon-wrap ion-icon{font-size:16px;color:#1976d2;}
    .footer-bar-6-modern a span{display:block;font-size:11px;}
    .footer-bar-6-modern a.active .icon-wrap,
    .footer-bar-6-modern a:hover .icon-wrap{background:#1976d2;}
    .footer-bar-6-modern a.active .icon-wrap i,
    .footer-bar-6-modern a.active .icon-wrap ion-icon,
    .footer-bar-6-modern a:hover .icon-wrap i,
    .footer-bar-6-modern a:hover .icon-wrap ion-icon{color:#fff;}
  </style>
</head>
<body>

  <!-- Header -->
  <div class="more-header">
    <h1>More Services</h1>
  </div>

  <!-- Services -->
  <div class="service-card">
    <div class="service-grid">
      <a href="electricity"><i class="fa fa-bolt"></i><span>Electricity</span></a>
      <a href="verify-bvn"><i class="fa fa-university"></i><span>BVN Slip</span></a>
      <a href="virtual-card"><i class="fa fa-credit-card"></i><span>Virtual Card</span></a>
      <a href="calculator"><i class="fa fa-calculator"></i><span>Calculator</span></a>

      <a href="issues"><i class="fa fa-envelope"></i><span>Message</span></a>
      <a href="pricing"><i class="fa fa-list"></i><span>Pricing</span></a>
      <a href="#agent-upgrade-modal" id="upgrade-agent-btn" data-menu="agent-upgrade-modal"><i class="fa fa-user-secret"></i><span>Agent</span></a>
      <a href="#vendor-upgrade-modal" id="upgrade-vendor-btn" data-menu="vendor-upgrade-modal"><i class="fa fa-store"></i><span>Vendor</span></a>

      <a href="buy-airtime"><i class="fa fa-phone"></i><span>Airtime</span></a>
      <a href="buy-data"><i class="fa fa-wifi"></i><span>Data</span></a>
      <a href="cable-tv"><i class="fa fa-tv"></i><span>Cable TV</span></a>
      <a href="exam-pins"><i class="fa fa-graduation-cap"></i><span>Education</span></a>

      <a href="buy-data-pin"><i class="fa fa-barcode"></i><span>Data Pin</span></a>
      <a href="airtime-to-cash"><i class="fa fa-mobile"></i><span>Airtime Swap</span></a>
      <a href="referrals"><i class="fa fa-users"></i><span>Referrals</span></a>
      <a href="profile"><i class="fa fa-code"></i><span>API Access</span></a>

      <a href="contact-us"><i class="fa fa-headset"></i><span>Contact</span></a>
    </div>
  </div>

  <!-- Footer -->
  <div id="footer-bar" class="footer-bar-6-modern">
    <a href="homepage"><div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div><span>Home</span></a>
    <a href="profile"><div class="icon-wrap"><i class="fa fa-user"></i></div><span>Profile</span></a>
    <a href="contact-us"><div class="icon-wrap"><i class="fa fa-headset"></i></div><span>Support</span></a>
    <a href="transactions"><div class="icon-wrap"><i class="fa fa-clock-rotate-left"></i></div><span>History</span></a>
    <a href="more-services" class="active"><div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div><span>More</span></a>
  </div>

</body>
</html>