<!DOCTYPE html>
<html lang="en">
     <!-- Page content start here-->
   <div class="page-content header-clear">
<head>
  <!-- Meta & Title -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>User Dashboard</title>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <!-- Styles -->
  <style>
    * {
      margin:0;
      padding:0;
      box-sizing:border-box;
      font-family: 'Poppins', sans-serif;
    }
    body {
      background:#f4f9ff;
      color:#222;
      line-height:1.6;
    }

    /* Wallet Section */
    .card-wallet {
      background:linear-gradient(135deg, #0048a8, #007bff);
      border-radius:1rem;
      box-shadow:0px 10px 25px rgba(0,0,0,0.2);
      color:#fff;
      padding:20px;
      margin:20px;
    }
    .card-wallet h1,
    .card-wallet h2 {
      color:#fff !important;
      margin:5px 0;
    }

    /* Buttons */
    .btn-modern {
      display:flex;
      align-items:center;
      justify-content:center;
      width:48%;
      padding:12px 16px;
      border-radius:1rem;
      font-weight:600;
      letter-spacing:0.3px;
      background-color:#007bff;
      color:#fff;
      border:none;
      box-shadow:0 5px 12px rgba(0,123,255,.3);
      transition:all 0.3s ease;
      text-decoration:none;
    }
    .btn-modern i {margin-right:5px;}
    .btn-modern:hover {
      background-color:#0056b3;
      transform:translateY(-2px);
    }
    .btn-whatsapp {
      background:#25d366 !important;
      box-shadow:0 5px 12px rgba(37,211,102,.3);
    }

    /* Section Title */
    .section-title {
      font-size:1rem;
      font-weight:700;
      margin:25px 20px 15px;
      color:#004280;
      border-left:4px solid #007bff;
      padding-left:8px;
    }

    /* Quick Actions */
    .actions {
      display:flex;
      flex-wrap:wrap;
      justify-content:space-between;
      padding:0 15px 30px;
    }
    .action-card {
      background:#ffffff;
      border-radius:1rem;
      box-shadow:0 5px 15px rgba(0,0,0,0.08);
      width:42%; /* rage daga 45% zuwa 42% */
      margin:8px 0; /* rage margin kadan */
      text-align:center;
      padding:12px; /* rage daga 15px zuwa 12px */
      transition:all 0.25s ease-in-out;
      text-decoration:none;
      color:#222;
    }
    .action-card:hover {
      transform:translateY(-5px);
      box-shadow:0 10px 25px rgba(0,0,0,0.15);
    }
    .action-card .icon {
      font-size:25px; /* dawo da girman asali */
      margin-bottom:8px;
      color:#007bff;
      transition: all 0.25s ease-in-out;
    }
    /* Hover effect for icon */
    .action-card:hover .icon {
      color:#0056b3;
      transform: scale(1.2) rotate(5deg);
    }
    .action-card p {
      font-size:0.85rem; /* rage kadan daga 0.9rem */
      font-weight:600;
    }

    /* Responsive */
    @media(max-width:600px){
      .btn-modern{width:100%; margin-bottom:10px;}
      .action-card{width:46%;} /* rage kadan a mobile */
    }
  </style>
</head>
<body>

  <!-- Wallet / Balance Section -->
  <div class="card-wallet">
    <div style="display:flex; justify-content:space-between; align-items:center;">
      <div>
        <h1 class="font-15 color-white mb-0">
          Hi, <?php echo $data->sFname. " " . $data->sLname.  " (".$controller->getUserPlanName($profileDetails->sType).")"; ?>
        </h1>
        <h2 class="font-20 mt-0 color-white">
          <span id="hideEyeDiv" style="display:none;">&#8358;<?php echo number_format($data->sWallet); ?></span>
          <span id="openEyeDiv">&#8358; *********</span>

          <span id="hideEye">
            <i class="fa fa-eye-slash" style="margin-left:20px;" aria-hidden="true"></i>
          </span>
          <span id="openEye" style="display:none; margin-left:20px;">
            <i class="fa fa-eye" aria-hidden="true"></i>
          </span>
        </h2>
        <h2 class="font-15 color-white">
          Commission: &#8358;<?php echo $data->sRefWallet; ?>
        </h2>
      </div>
    </div>
  </div>

  <!-- Buttons (Action Row) -->
  <div style="display:flex; justify-content:space-between; padding:0 20px; gap:10px; margin-top:-10px;">
    <a href="fund-wallet" class="btn-modern"><i class="fa fa-plus-circle"></i> Add Money</a>
    <a href="contact-us" class="btn-modern btn-whatsapp"><i class="fab fa-whatsapp"></i> Contact Us</a>
  </div>

  <!-- Quick Actions -->
  <p class="section-title">What Would You Like To Do Today?</p>
  <div class="actions">
    <a href="buy-airtime" class="action-card">
      <div class="icon"><i class="fa fa-phone"></i></div>
      <p>Airtime</p>
    </a>
    <a href="buy-data" class="action-card">
      <div class="icon"><i class="fa fa-wifi"></i></div>
      <p>Data</p>
    </a>
    <a href="cable-tv" class="action-card">
      <div class="icon"><i class="fa fa-tv"></i></div>
      <p>Cable TV</p>
    </a>
    <a href="electricity" class="action-card">
      <div class="icon"><i class="fa fa-bolt"></i></div>
      <p>Electricity</p>
    </a>
    <a href="exam-pins" class="action-card">
      <div class="icon"><i class="fa fa-graduation-cap"></i></div>
      <p>Education</p>
    </a>
    <a href="referrals" class="action-card">
      <div class="icon"><i class="fa fa-users"></i></div>
      <p>Referrals</p>
    </a>
  </div>

</body>
</html>
