<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1.0"/>
  <title>Fund Wallet - <?php echo $sitename; ?></title>

  <!-- Icons & Bootstrap -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="../assets/styles/bootstrap.css">
  <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
  <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons.js"></script>

  <style>
    body{font-family:'Poppins',sans-serif;background:#f4f9ff;padding-bottom:70px;}

    /* Header */
    .page-header{
      background:linear-gradient(135deg,#0d47a1,#1976d2);
      color:#fff;text-align:center;
      padding:20px 15px;
      font-weight:600;box-shadow:0 4px 12px rgba(0,0,0,0.2);
      border-bottom-left-radius:20px;border-bottom-right-radius:20px;
      margin-bottom:15px;position:sticky;top:0;z-index:1000;
    }
    .page-header h1{margin:0;font-size:18px;}

    /* Tabs */
    .tab-controls{
      display:flex;justify-content:space-around;margin-bottom:15px;
      border-radius:8px;background:#f1f5fb;padding:5px;
    }
    .tab-controls a{
      flex:1;text-align:center;
      padding:8px 0;
      border-radius:6px;
      font-size:14px;font-weight:600;
      color:#444;text-decoration:none;
      transition:.25s;
    }
    .tab-controls a:hover{background:#e3edfb;}
    .tab-controls a[data-active], .tab-controls a.active {
      background:#1976d2;color:#fff;
    }

    /* Card */
    .card-style{
      background:#fff; border-radius:12px;
      padding:15px;margin:15px;
      box-shadow:0 4px 12px rgba(0,0,0,0.08);
    }

    /* Buttons */
    .btn-modern{
      display:block;width:100%;
      background:#1976d2;
      color:#fff;font-weight:600;
      border:none;border-radius:8px;
      padding:10px;margin-top:10px;
      transition:.25s;
    }
    .btn-modern:hover{background:#0d47a1;}
  </style>
</head>
<body>

  <!-- Header -->
  <div class="page-header">
    <h1>Fund Wallet</h1>
  </div>

  <!-- Tabs -->
  <div class="card-style">
    <div class="tab-controls" id="fundTabs">
      <a href="#tab-1" class="active" data-bs-toggle="collapse" data-bs-target="#tab-1">Automated</a>
      <a href="#tab-3" data-bs-toggle="collapse" data-bs-target="#tab-3">Manual</a>
      <!-- <a href="#tab-2" data-bs-toggle="collapse" data-bs-target="#tab-2">Card</a> -->
    </div>

    <div class="collapse show" id="tab-1" data-bs-parent="#fundTabs">
      <h5 class="mb-2">Automated Bank Funding</h5>
      <p class="text-muted small">Generate virtual accounts from our partners (Palmpay, 9PSB, Monnify, etc). Transfers here reflect instantly to your wallet. Charges apply.</p>
      
                    <!-- BILLSTACK BANK START-->
<?php 
if ($controller->getConfigValue($data2, "billstackStatus") == "On"): 
    $billstackCharges = $controller->getConfigValue($data2, "billstackCharges");
    $billstackChargesType = $controller->getConfigValue($data2, "billstackChargesType");
    $billstackChargesText = ($billstackChargesType == "flat") ? "N" . $billstackCharges : $billstackCharges . "%";
?>

    <?php if (empty($data->sPalmpayBank)): ?>
        <p class="mb-2 text-danger font-600 font-15">Get a Palmpay Bank Account for Automated Transfer. Generate a dedicated account number now. Funding attracts <?php echo $billstackChargesText; ?> only.</p>
        <form method="POST" id="billstackForm">
            <input type="hidden" name="generate-billstack-account" value="YES" />
        </form>
        <button class="btn btn-primary font-700 rounded-xl mt-3" id="billstackBtn" onclick="$('#billstackBtn').removeClass('btn-primary').addClass('btn-secondary').html('<i class=\'fa fa-spinner fa-spin\'></i> Processing ...'); $('#billstackForm').submit();">Generate Account</button>
    <?php else: ?>
        <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>Palmpay Bank</p>
        <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sPalmpayBank; ?></p>
        <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $billstackChargesText; ?> only.</p>
        <button class="btn btn-primary font-700 rounded-xl mt-3" onclick="copyToClipboard('<?php echo $data->bsprovidus; ?>')">Copy Account No</button>
    <?php endif; ?>

    <hr />
<?php endif; ?>
<!-- BILLSTACK BANK END -->
                    
                    
                    <!-- PAYVESSEL BANK START-->
                  <?php if($controller->getConfigValue($data2,"payvesselStatus") == "On"): ?>
                  <?php $payvesCharges = $controller->getConfigValue($data2,"payvesselCharges"); 
                  $payvesChargesType = $controller->getConfigValue($data2,"payvesselChargesType"); 
                  $payvesChargesText = ($payvesChargesType == "flat") ? "N".$payvesCharges : $payvesCharges."%";?>
                  <?php $generatedAccountNumber = $controller->generatePayvesselDynamic();?> 
                 <?php  if($data->pVerify == "yes"): ?>
                 <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>9Payment Service Bank (9PSB)</p>
                 <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sPayvesselBank; ?></p>
                 <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $payvesChargesText; ?> only.</p>
                 <button class="btn btn-primary font-700 rounded-xl mt-3" onclick="copyToClipboard('<?php echo $data->sPayvesselBank; ?>')">Copy Account No</button>
                 <?php else: ?>

                 <?php if(empty($generatedAccountNumber)): ?>
                 <p class="mb-2 text-danger font-600 font-15">Get 9Payment Account. <?php echo $payvesChargesText; ?> Charge only.</p>
                 <p class="mb-2"><b>Note: </b> This is dynamic account and is a TEMPORARY account for funding, can only be used ONE TIME. <?php echo $payvesChargesText; ?> Charge only. <br> <a href="payvessel-verify" class="text-danger"> <b>[ Or Get Permanent 9Payment Account ]</b></a></p>
                 <form method="POST" id="payvesform"><input type="hidden" name="generate-payvessel-dynamic" value="YES" />
                 <input type="hidden" name="id" value="<?php echo $data->sId;?>" /></form>
                 <button class="btn btn-primary font-700 rounded-xl mt-3" id="payvesbtn" onclick="$('#payvesbtn').removeClass('btn-primary'); $('#payvesbtn').addClass('btn-secondary'); $('#payvesbtn').html('<i class=\'fa fa-spinner fa-spin\'></i> Processing ...'); $('#payvesform').submit();">Generate Account</button>
                 <?php else: ?>
                 
                 <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>9Payment Service Bank (9PSB)</p>
                 <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $generatedAccountNumber; ?></p>
                 <p class="mb-2"><b>Note: </b> Do not save this account as beneficiary, can only be used ONE TIME. <br> <a href="payvessel-verify" class="text-danger"> <b>[ Or Get Permanent 9Payment Account ]</b></a> </p>
                <button class="btn btn-primary font-700 rounded-xl mt-3" onclick="copyToClipboard('<?php echo $generatedAccountNumber; ?>')">Copy Account No</button>
                <?php endif; ?><?php endif; ?><?php endif; ?><hr/>

                <!-- PAYVESSEL BANK END -->
                    
                    <!-- ASPFIY BANK START-->
                    <?php
                    
                    //print_r($data2);
                    //die();
                    
                    if($controller->getConfigValue($data2,"asfiyStatus") == "On"): ?>
                    <?php 
                    $asfiyCharges = $controller->getConfigValue($data2,"asfiyCharges");
                    $asfiyChargesType = $controller->getConfigValue($data2,"asfiyChargesType"); ?>
                    <?php $asfiyChargesText = ($asfiyChargesType == "flat") ? "N".$asfiyCharges : $asfiyCharges."%"; ?>
                    <?php if(empty($data->sPaga)): ?>
                        <p class="mb-2 text-danger font-600 font-15">Get A Palmpay Account For Automated Transfer, Generate A Dedicated Account Number Now. Funding Attracts <?php echo $asfiyChargesText; ?> only.</p>
                        <form method="POST" id="aspfiyform1"><input type="hidden" name="generate-aspfiy-palmpay" value="YES" /></form>
                        <button class="btn btn-primary font-700  mt-3" id="aspfiybtn1" onclick="$('#aspfiybtn1').removeClass('btn-primary'); $('#aspfiybtn1').addClass('btn-secondary'); $('#aspfiybtn1').html('<i class=\'fa fa-spinner fa-spin\'></i> Processing ...'); $('#aspfiyform1').submit();" style="background:#f2f2f2; color :<?php echo $sitecolor; ?>;">Generate Account</button>
                    <?php else: ?>
                    <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>Palmpay Microfinance Bank</p>
                    
                    <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sPaga; ?></p>
                    
                    <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $asfiyChargesText; ?> only.</p>
                    <button class="btn btn-primary font-700  mt-3" onclick="copyToClipboard('<?php echo $data->sPaga; ?>')" style="background:#f2f2f2; color :<?php echo $sitecolor; ?>;">Copy Account No</button>
                    <?php endif; ?>
                    <hr/>
                    <?php endif; ?>
                    
                    <?php
                    
                    //print_r($data2);
                    //die();
                    
                    if($controller->getConfigValue($data2,"asfiyStatus") == "On"): ?>
                    <?php 
                    $asfiyCharges = $controller->getConfigValue($data2,"asfiyCharges");
                    $asfiyChargesType = $controller->getConfigValue($data2,"asfiyChargesType"); ?>
                    <?php $asfiyChargesText = ($asfiyChargesType == "flat") ? "N".$asfiyCharges : $asfiyCharges."%"; ?>
                    <?php if(empty($data->sAsfiyBank)): ?>
                        <p class="mb-2 text-danger font-600 font-15">Get A Paga Account For Automated Transfer, Generate A Dedicated Account Number Now. Funding Attracts <?php echo $asfiyChargesText; ?> only.</p>
                        <form method="POST" id="aspfiyform"><input type="hidden" name="generate-aspfiy-account" value="YES" /></form>
                        <button class="btn btn-primary font-700  mt-3" id="aspfiybtn" onclick="$('#aspfiybtn').removeClass('btn-primary'); $('#aspfiybtn').addClass('btn-secondary'); $('#aspfiybtn').html('<i class=\'fa fa-spinner fa-spin\'></i> Processing ...'); $('#aspfiyform').submit();" style="background:#f2f2f2; color :<?php echo $sitecolor; ?>;">Generate Account</button>
                    <?php else: ?>
                    <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>Paga Microfinance Bank</p>
                    <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sAsfiyBank; ?></p>
                    <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $asfiyChargesText; ?> only.</p>
                    <button class="btn btn-primary font-700  mt-3"  onclick="copyToClipboard('<?php echo $data->sAsfiyBank; ?>')" style="background:#f2f2f2; color :<?php echo $sitecolor; ?>;">Copy Account No</button>
                    <?php endif; ?>
                    <hr/>
                    <?php endif; ?>
                    
                    <?php  if($profileDetails->sKycStatus <> "verified" && $siteSettings->kycShouldEnable == "yes"): ?>
                        

                        <div id="kycNoteBox" class="border" style="padding:20px;">
                            <img src="../../assets/images/icons/user-verify.png" style="width:50px; height:50px;" />

                            <p class="mb-0 font-600 color-highlight">KYC Verification</p>
                            <h1>Account Verification</h1>
                            <h6 class="color-highlight">Get A Dedicated Bank Account For Fast And Automatic Funding</h6>
                            <hr />
                            <p class="mb-1 font-600 text-danger">As Required By The Central Bank Of Nigeria (CBN), Before You Can Fund Your Wallet With A Virtual Account, We Would Need To Verify Your Identity Using Your NIN or BVN. This Process Is Automatic And You Would Be Able To Fund Your Wallet Once Verified.</p>
                            
                            <a href="kyc-verification" style="width: 100%;" class="the-form-btn btn btn-full btn-l font-600 font-15 gradient-highlight mt-4 rounded-s">
                                            Start Verification
                            </a>

                        </div>
                    <?php else: ?>


                     
                    <!-- MONNIFY BANK START -->
                    <?php if($controller->getConfigValue($data2,"monifyStatus") == "On"): ?>
                        <?php $chargesText = $controller->getConfigValue($data2,"monifyCharges"); ?>
                        <?php if($chargesText == 50 || $chargesText == "50"){$chargesText = "N".$chargesText;} else {$chargesText = $chargesText."%";} ?>
                        <?php if($controller->getConfigValue($data2,"monifyGtStatus") == "On"): ?>
                        <?php if(empty($data->sGtBank)): ?>
                            <p class="mb-2 text-danger font-600 font-15">Get A GT Bank Account For Automated Transfer, Generate A Dedicated Account Number Now. Funding Attracts <?php echo $chargesText; ?> only.</p>
                            <form method="POST" id="gtbankform"><input type="hidden" name="generate-gtbank-account" value="YES" /></form>
                            <button class="btn btn-primary font-700 rounded-xl mt-3" id="gtbankbtn" onclick="$('#gtbankbtn').removeClass('btn-primary'); $('#gtbankbtn').addClass('btn-secondary'); $('#gtbankbtn').html('<i class=\'fa fa-spinner fa-spin\'></i> Processing ...'); $('#gtbankform').submit();">Generate Account</button>
                        <?php else: ?>
                            <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>GT Bank</p>
                            <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sGtBank; ?></p>
                            <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $chargesText; ?> only.</p>
                            <button class="btn btn-primary font-700 rounded-xl mt-3" onclick="copyToClipboard('<?php echo $data->sGtBank; ?>')">Copy Account No</button>
                        <?php endif; ?>
                        <hr/>
                        <?php endif; if($controller->getConfigValue($data2,"monifyFeStatus") == "On"): ?>
                        <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>Fidelity  Bank</p>
                        <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sFidelityBank; ?></p>
                        <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $chargesText; ?> only.</p>
                        <button class="btn btn-primary font-700 rounded-xl mt-3" onclick="copyToClipboard('<?php echo $data->sFidelityBank; ?>')">Copy Account No</button>
                        <hr/>
                        <?php endif; if($controller->getConfigValue($data2,"monifyMoStatus") == "On"): ?>
                        <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>Moniepoint Bank</p>
                        <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sRolexBank; ?></p>
                        <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $chargesText; ?> only.</p>
                        <button class="btn btn-primary font-700 rounded-xl mt-3" onclick="copyToClipboard('<?php echo $data->sRolexBank; ?>')">Copy Account No</button>
                        <hr/>
                        <?php endif; if($controller->getConfigValue($data2,"monifyWeStatus") == "On"): ?>
                        <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: Wema Bank</p>
                        <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sBankNo; ?></p>
                        <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $chargesText; ?> only.</p>
                        <button class="btn btn-primary font-700 rounded-xl mt-3" onclick="copyToClipboard('<?php echo $data->sBankNo; ?>')">Copy Account No</button>
                        <hr/>
                        <?php endif; if($controller->getConfigValue($data2,"monifySaStatus") == "On"): ?>
                        <p class="mb-2 text-dark font-600 font-16"><b>Bank Name: </b>Sterling Bank</p>
                        <p class="mb-2 text-dark font-600 font-16"><b>Account No: </b><?php echo $data->sSterlingBank; ?></p>
                        <p class="mb-2 text-danger font-600 font-15"><b>Note: </b> Automated bank transfer attracts additional charges of <?php echo $chargesText; ?> only.</p>
                        <button class="btn btn-primary font-700 rounded-xl mt-3" onclick="copyToClipboard('<?php echo $data->sSterlingBank; ?>')">Copy Account No</button>
                        <?php endif; ?>
                    <?php endif; ?>
                    <!-- MONNIFY BANK END -->
                    <?php endif; ?>
                </div>

    <div class="collapse" id="tab-3" data-bs-parent="#fundTabs">
      <h5 class="mb-2">Manual Transfer</h5>
      <p class="text-muted small">Send funds to the company account below then contact admin:</p>
      <p><b>Bank:</b> <?php echo $data3->bankname;?></p>
      <p><b>Account Name:</b> <?php echo $data3->accountname;?></p>
      <p><b>Account No:</b> <?php echo $data3->accountno;?></p>
      <button class="btn-modern" onclick="copyToClipboard('<?php echo $data3->accountno;?>')">Copy Account No</button>
      <a href="https://wa.me/234<?php echo $data3->whatsapp;?>" class="btn-modern" style="background:#25d366;">Contact Admin on WhatsApp</a>
    </div>

  </div>

  <!-- Footer -->
  <div id="footer-bar" class="footer-bar-6-modern">
    <a href="homepage"><div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div><span>Home</span></a>
    <a href="profile"><div class="icon-wrap"><i class="fa fa-user"></i></div><span>Profile</span></a>
    <a href="contact-us"><div class="icon-wrap"><i class="fa fa-headset"></i></div><span>Support</span></a>
    <a href="transactions"><div class="icon-wrap"><i class="fa fa-clock-rotate-left"></i></div><span>History</span></a>
    <a href="more-services" class="active"><div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div><span>More</span></a>
  </div>

</body>
</html>