<div class="page-content header-clear-medium">

  <!-- Sticky Header -->
  <div class="page-header text-center text-white py-3 mb-3"
       style="background: linear-gradient(135deg,#0d47a1,#1976d2);
              border-bottom-left-radius:20px;border-bottom-right-radius:20px;
              position:sticky;top:0;z-index:1000;">
    <h5 class="mb-0">Electricity Bill Payment</h5>
  </div>

  <div class="card card-style shadow-sm" style="border-radius:15px;">
    <div class="content">

      <p class="mb-1 text-center fw-semibold text-primary">Pay Electricity Bills for All Providers</p>

      <!-- Provider Logos -->
      <div class="row text-center mb-3">
        <a href="javascript:selectExamByIcon('Abuja  Electric');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/aedc.png" width="40" height="40" />
          </span>
        </a>
        <a href="javascript:selectExamByIcon('Eko Electric');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/ekedc.png" width="40" height="40" />
          </span>
        </a>
        <a href="javascript:selectExamByIcon('Kaduna Electric');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/kaduna.png" width="40" height="40" />
          </span>
        </a>
        <a href="javascript:selectExamByIcon('Kano Electric');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/kedco.png" width="40" height="40" />
          </span>
        </a>
        <a href="javascript:selectExamByIcon('Jos Electric');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/jos.png" width="40" height="40" />
          </span>
        </a>
        <a href="javascript:selectExamByIcon('Ikeja Electric');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/ikeja.png?v=1" width="40" height="40" />
          </span>
        </a>
        <a href="javascript:selectExamByIcon('Ibadan Electric');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/ibedc.png" width="40" height="40" />
          </span>
        </a>
        <a href="javascript:selectExamByIcon('Port Harcourt Electric');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/phedc.png?v=1" width="40" height="40" />
          </span>
        </a>
      </div>

      <hr/>

      <!-- Form -->
      <form method="post" class="verifyelectricityplanForm" id="verifyelectricityplanForm" action="confirm-electricity">
        <fieldset>

          <!-- Provider Select -->
          <div class="mb-3">
            <label for="electricityid" class="form-label small fw-bold text-secondary">Provider</label>
            <select id="electricityid" name="provider" class="form-select" required>
              <option value="" disabled selected>Select Provider</option>
              <?php foreach($data AS $provider): if($provider->providerStatus=="On"): ?>
                <option value="<?php echo $provider->eId; ?>" providername="<?php echo $provider->provider; ?>">
                  <?php echo $provider->provider; ?>
                </option>
              <?php endif; endforeach; ?>
            </select>
          </div>

          <input type="hidden" name="electricitydetails" id="electricitydetails" />

          <!-- Meter Type -->
          <div class="mb-3">
            <label for="metertype" class="form-label small fw-bold text-secondary">Meter Type</label>
            <select id="metertype" name="metertype" class="form-select" required>
              <option value="" disabled selected>Select Type</option>
              <option value="prepaid">Prepaid</option>
              <option value="postpaid">Postpaid</option>
            </select>
          </div>

          <!-- Customer Phone -->
          <div class="mb-3">
            <label for="phone" class="form-label small fw-bold text-secondary">Customer Phone Number</label>
            <input type="number" name="phone" id="phone" class="form-control" placeholder="Phone Number" required />
          </div>

          <!-- Meter Number -->
          <div class="mb-3">
            <label for="meternumber" class="form-label small fw-bold text-secondary">Meter Number</label>
            <input type="number" name="meternumber" class="form-control" placeholder="Meter Number" required />
          </div>

          <!-- Amount -->
          <div class="mb-3">
            <label for="meteramount" class="form-label small fw-bold text-secondary">Amount</label>
            <input type="text" name="amount" id="meteramount" class="form-control" placeholder="Amount" required />
          </div>

          <!-- Amount To Pay -->
          <div class="mb-3">
            <label for="amounttopay" class="form-label small fw-bold text-secondary">Amount To Pay</label>
            <input type="text" name="amounttopay" id="amounttopay" class="form-control" placeholder="Amount To Pay" readonly required />
          </div>

          <p class="text-danger small">
            <b>Note:</b> Transaction attracts a service charge of N<span id="electricitycharges"><?php echo $data2->electricitycharges; ?></span> only.<br/>
            <b>Note:</b> Minimum Unit Purchase Is N1000.
          </p>

          <!-- Submit -->
          <button type="submit" id="electricity-btn" name="verify-meter-no"
                  class="btn w-100 fw-bold py-2 text-white"
                  style="background:<?php echo $sitecolor; ?>;">
            Continue
          </button>
        </fieldset>
      </form>
    </div>
  </div>
</div>

<!-- FOOTER (unified fintech style) -->
<div id="footer-bar" class="footer-bar-6-modern">
  <a href="homepage">
    <div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div>
    <span>Home</span>
  </a>
  <a href="profile">
    <div class="icon-wrap"><i class="fa fa-user"></i></div>
    <span>Profile</span>
  </a>
  <a href="contact-us">
    <div class="icon-wrap"><i class="fa fa-headset"></i></div>
    <span>Support</span>
  </a>
  <a href="transactions">
    <div class="icon-wrap"><i class="fa-solid fa-clock-rotate-left"></i></div>
    <span>History</span>
  </a>
  <a href="more-services">
    <div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div>
    <span>More</span>
  </a>
</div>

<style>
.footer-bar-6-modern {
  position: fixed; bottom:0; left:0; right:0;
  height:60px;
  background:#fff;
  display:flex; justify-content:space-around; align-items:center;
  border-top:1px solid #e0e0e0;
  box-shadow:0 -2px 10px rgba(0,0,0,.08);
  z-index:9999;
}
.footer-bar-6-modern a {
  flex:1; text-align:center; text-decoration:none; color:#555; font-size:11px;
}
.footer-bar-6-modern a span {
  display:block; font-size:11px; margin-top:2px;
}
.icon-wrap {
  width:28px; height:28px; border-radius:50%;
  background:#f5f7fa;
  display:flex; align-items:center; justify-content:center;
  margin:0 auto 3px; transition:.3s;
}
.icon-wrap i, .icon-wrap ion-icon {
  font-size:16px; color:#1976d2; transition:.2s;
}
.footer-bar-6-modern a.active .icon-wrap,
.footer-bar-6-modern a:hover .icon-wrap {background:#1976d2;}
.footer-bar-6-modern a.active .icon-wrap i,
.footer-bar-6-modern a.active .icon-wrap ion-icon,
.footer-bar-6-modern a:hover .icon-wrap i,
.footer-bar-6-modern a:hover .icon-wrap ion-icon {color:#fff;}
</style>