<!DOCTYPE html>
<html lang="en">
        <!-- Page content start here-->
        <div class="page-content header-clear-medium">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1.0"/>
  <title>Support - <?php echo $sitename; ?></title>

  <!-- Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
  <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>

  <style>
    body{font-family:'Poppins',sans-serif;background:#f4f9ff;padding-bottom:70px;}
    .support-header{
      background:linear-gradient(135deg,#0d47a1,#1976d2);
      color:#fff;text-align:center;
      padding:40px 20px;border-bottom-left-radius:30px;border-bottom-right-radius:30px;
      box-shadow:0 4px 12px rgba(0,0,0,0.2);
    }
    .support-header img{
      width:85px;height:85px;border-radius:50%;
      border:3px solid #fff;margin-bottom:10px;
      box-shadow:0 4px 10px rgba(0,0,0,0.3);
    }
    .support-header h1{font-size:22px;margin-bottom:5px;}
    .support-header p{font-size:14px;opacity:0.9;}
    .support-card{
      background:#fff;margin:20px;border-radius:15px;
      box-shadow:0 4px 15px rgba(0,0,0,0.05);padding:15px;
    }
    .support-list a{
      display:flex;align-items:center;justify-content:space-between;
      padding:12px 10px;background:#fff;border-radius:10px;margin:8px 0;
      text-decoration:none;color:#333;font-size:14px;transition:all .2s;
      box-shadow:0 2px 6px rgba(0,0,0,0.05);
    }
    .support-list a:hover{transform:translateX(3px);box-shadow:0 3px 8px rgba(0,0,0,0.1);}
    .support-list i:first-child{font-size:18px;margin-right:10px;color:#1976d2;}
    .support-list span{flex:1;}
    .support-list i:last-child{color:#999;}
    
    /* Footer style same as before */
    .footer-bar-6-modern {
      position: fixed;bottom:0;left:0;right:0;height:60px;
      background:#fff;display:flex;justify-content:space-around;align-items:center;
      border-top:1px solid #e0e0e0;box-shadow:0 -2px 10px rgba(0,0,0,.08);
      z-index:9999;
    }
    .footer-bar-6-modern a{
      flex:1;text-align:center;text-decoration:none;color:#555;font-size:11px;
    }
    .footer-bar-6-modern .icon-wrap{
      width:28px;height:28px;background:#f5f7fa;border-radius:50%;
      display:flex;align-items:center;justify-content:center;
      margin:0 auto 3px;transition:.3s;
    }
    .footer-bar-6-modern .icon-wrap i,
    .footer-bar-6-modern .icon-wrap ion-icon{font-size:16px;color:#1976d2;}
    .footer-bar-6-modern a span{display:block;font-size:11px;}
    .footer-bar-6-modern a.active .icon-wrap,
    .footer-bar-6-modern a:hover .icon-wrap{background:#1976d2;}
    .footer-bar-6-modern a.active .icon-wrap i,
    .footer-bar-6-modern a.active .icon-wrap ion-icon,
    .footer-bar-6-modern a:hover .icon-wrap i,
    .footer-bar-6-modern a:hover .icon-wrap ion-icon{color:#fff;}
  </style>
</head>
<body>

  <!-- Support Header -->
  <div class="support-header">
    <img src="../../assets/images/support.png?v=1" alt="Support">
    <h1>Contact Us</h1>
    <p>Stay In Touch With Us</p>
  </div>

  <!-- Support Content -->
  <div class="support-card">
    <div class="support-list">
      <a href="faq">
        <i class="fa fa-circle-question"></i>
        <span>Frequently Asked Questions</span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="issues">
        <i class="fa fa-envelope"></i>
        <span>Report an Issue</span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="tel:<?php echo $data->phone; ?>">
        <i class="fa fa-phone"></i>
        <span><?php echo $data->phone; ?></span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="mailto:<?php echo $data->email; ?>">
        <i class="fa fa-envelope"></i>
        <span><?php echo $data->email; ?></span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="https://wa.me/234<?php echo $data->whatsapp; ?>">
        <i class="fab fa-whatsapp text-success"></i>
        <span>Whatsapp</span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="<?php echo $data->whatsappgroup; ?>">
        <i class="fab fa-whatsapp text-success"></i>
        <span>Whatsapp Group</span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="<?php echo $data->facebook; ?>">
        <i class="fab fa-facebook text-primary"></i>
        <span>Facebook</span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="<?php echo $data->instagram; ?>">
        <i class="fab fa-instagram text-danger"></i>
        <span>Instagram</span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="<?php echo $data->twitter; ?>">
        <i class="fab fa-twitter text-primary"></i>
        <span>Twitter</span>
        <i class="fa fa-angle-right"></i>
      </a>
      <a href="https://t.me/<?php echo $data->telegram; ?>">
        <i class="fab fa-telegram text-primary"></i>
        <span>Telegram</span>
        <i class="fa fa-angle-right"></i>
      </a>
    </div>
  </div>

  <!-- Footer -->
  <div id="footer-bar" class="footer-bar-6-modern">
    <a href="homepage">
      <div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div><span>Home</span>
    </a>
    <a href="profile">
      <div class="icon-wrap"><i class="fa fa-user"></i></div><span>Profile</span>
    </a>
    <a href="contact-us" class="active">
      <div class="icon-wrap"><i class="fa fa-headset"></i></div><span>Support</span>
    </a>
    <a href="transactions">
      <div class="icon-wrap"><i class="fa fa-clock-rotate-left"></i></div><span>History</span>
    </a>
    <a href="more-services">
      <div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div><span>More</span>
    </a>
  </div>

</body>
</html>