<div class="page-content header-clear-medium">

  <!-- Sticky Header -->
  <div class="page-header text-center text-white py-3 mb-3"
       style="background: linear-gradient(135deg,#0d47a1,#1976d2);
              border-bottom-left-radius:20px;border-bottom-right-radius:20px;
              position:sticky;top:0;z-index:1000;">
    <h5 class="mb-0">Cable TV Subscription</h5>
  </div>

  <div class="card card-style shadow-sm" style="border-radius:15px;">
    <div class="content">

      <p class="mb-1 text-center fw-semibold text-primary">Cable TV Packages for All Providers</p>
      <p class="text-danger small text-center mb-3">
        For assistance, contact DSTV/GOtv on 01-2703232 / 08039003788 or toll free 08149860333, 07080630333, 09090630333. 
        For STARTIMES, call 094618888 or 014618888.
      </p>

      <!-- Provider Logos -->
      <div class="row text-center mb-3">
        <div class="col-4 mt-2">
          <a href="javascript:selectExamByIcon('DSTV');" class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/dstv.png" width="60" height="45" alt="DSTV"/>
          </a>
        </div>
        <div class="col-4 mt-2">
          <a href="javascript:selectExamByIcon('GOTV');" class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/gotv.png" width="65" height="45" alt="GOTV"/>
          </a>
        </div>
        <div class="col-4 mt-2">
          <a href="javascript:selectExamByIcon('STARTIMES');" class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/startimes.png" width="60" height="45" alt="STARTIMES"/>
          </a>
        </div>
      </div>

      <hr/>

      <!-- Form -->
      <form method="post" class="verifycableplanForm" id="verifycableplanForm" action="confirm-cable-tv">
        <fieldset>

          <!-- Provider Select -->
          <div class="mb-3">
            <label for="cableid" class="form-label small fw-bold text-secondary">Provider</label>
            <select id="cableid" name="provider" class="form-select" required>
              <option value="" disabled selected>Select Provider</option>
              <?php foreach($data AS $provider): if($provider->providerStatus=="On"): ?>
                <option value="<?php echo $provider->cId;?>" providername="<?php echo $provider->provider;?>">
                  <?php echo $provider->provider;?>
                </option>
              <?php endif; endforeach;?>
            </select>
          </div>

          <input type="hidden" name="cabledetails" id="cabledetails" />

          <!-- Plan Select -->
          <div class="mb-3">
            <label for="cableplan" class="form-label small fw-bold text-secondary">Plan</label>
            <select id="cableplan" name="cableplan" class="form-select" required></select>
          </div>

          <!-- Amount to Pay -->
          <div class="mb-3">
            <label for="amounttopay" class="form-label small fw-bold text-secondary">Amount To Pay</label>
            <input type="text" name="amounttopay" id="amounttopay" class="form-control" readonly required />
          </div>

          <!-- Subscription Type -->
          <div class="mb-3">
            <label for="subtype" class="form-label small fw-bold text-secondary">Subscription Type</label>
            <select id="subtype" name="subtype" class="form-select" required>
              <option value="" disabled selected>Select Type</option>
              <option value="change">Change</option>
              <option value="renew">Renew</option>
            </select>
          </div>

          <!-- Customer Phone -->
          <div class="mb-3">
            <label for="phone" class="form-label small fw-bold text-secondary">Customer Phone Number</label>
            <input type="number" name="phone" id="phone" class="form-control" placeholder="Phone Number" required />
          </div>

          <!-- IUC Number -->
          <div class="mb-3">
            <label for="iucnumber" class="form-label small fw-bold text-secondary">IUC Number</label>
            <input type="number" name="iucnumber" class="form-control" placeholder="IUC Number" required />
          </div>

          <p id="verifyer" class="small text-muted"></p>

          <!-- Submit -->
          <button type="submit" id="cable-btn" name="verify-cable-sub"
                  class="btn w-100 fw-bold py-2 text-white"
                  style="background:<?php echo $sitecolor; ?>;">
            Continue
          </button>
        </fieldset>
      </form>
    </div>
  </div>
</div>

<!-- FOOTER (unified fintech style) -->
<div id="footer-bar" class="footer-bar-6-modern">
  <a href="homepage">
    <div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div>
    <span>Home</span>
  </a>
  <a href="profile">
    <div class="icon-wrap"><i class="fa fa-user"></i></div>
    <span>Profile</span>
  </a>
  <a href="contact-us">
    <div class="icon-wrap"><i class="fa fa-headset"></i></div>
    <span>Support</span>
  </a>
  <a href="transactions">
    <div class="icon-wrap"><i class="fa fa-clock-rotate-left"></i></div>
    <span>History</span>
  </a>
  <a href="more-services">
    <div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div>
    <span>More</span>
  </a>
</div>

<style>
.footer-bar-6-modern {
  position: fixed; bottom:0; left:0; right:0;
  height:60px;
  background:#fff;
  display:flex; justify-content:space-around; align-items:center;
  border-top:1px solid #e0e0e0;
  box-shadow:0 -2px 10px rgba(0,0,0,.08);
  z-index:9999;
}
.footer-bar-6-modern a {
  flex:1; text-align:center; text-decoration:none; color:#555; font-size:11px;
}
.footer-bar-6-modern a span {
  display:block; font-size:11px; margin-top:2px;
}
.icon-wrap {
  width:28px; height:28px; border-radius:50%;
  background:#f5f7fa;
  display:flex; align-items:center; justify-content:center;
  margin:0 auto 3px; transition:.3s;
}
.icon-wrap i, .icon-wrap ion-icon {
  font-size:16px; color:#1976d2; transition:.2s;
}
.footer-bar-6-modern a.active .icon-wrap,
.footer-bar-6-modern a:hover .icon-wrap {background:#1976d2;}
.footer-bar-6-modern a.active .icon-wrap i,
.footer-bar-6-modern a.active .icon-wrap ion-icon,
.footer-bar-6-modern a:hover .icon-wrap i,
.footer-bar-6-modern a:hover .icon-wrap ion-icon {color:#fff;}
</style>