<div class="page-content header-clear-medium">

  <div class="card card-style shadow-sm" style="border-radius:15px;">
    <div class="content">

      <!-- Header -->
      <p class="mb-1 text-center fw-semibold text-primary">Airtime For All Networks</p>
      <h2 class="text-center mb-3">Buy Airtime</h2>

      <!-- Network Logos -->
      <div class="row text-center mb-3">
        <a href="javascript:selectNetworkByIcon('MTN');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/mtn.png" width="40" height="40" alt="MTN"/>
          </span>
        </a>
        <a href="javascript:selectNetworkByIcon('AIRTEL');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/airtel.png" width="40" height="40" alt="Airtel"/>
          </span>
        </a>
        <a href="javascript:selectNetworkByIcon('GLO');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/glo.png" width="40" height="40" alt="GLO"/>
          </span>
        </a>
        <a href="javascript:selectNetworkByIcon('9MOBILE');" class="col-3 mt-2">
          <span class="d-inline-block bg-light p-2 rounded shadow-sm">
            <img src="../../assets/images/icons/9mobile.png" width="40" height="40" alt="9Mobile"/>
          </span>
        </a>
      </div>

      <!-- Codes Marquee -->
      <div class="d-flex align-items-center mb-3">
        <h6 class="px-3 py-2 mb-0 me-2 text-white rounded" style="background:<?php echo $sitecolor; ?>;">Codes:</h6>
        <marquee class="flex-fill bg-light px-3 py-1 rounded-pill small fw-semibold text-dark" scrollamount="5">
          [MTN] *310# &nbsp; | &nbsp; [Airtel] *310# &nbsp; | &nbsp; [Glo] *310*1# &nbsp; | &nbsp; [9Mobile] *310#
        </marquee>
      </div>

      <hr/>

      <!-- Form -->
      <form method="post" class="airtimeForm" id="airtimeForm" action="buy-airtime">
        <fieldset>

          <!-- Network Select -->
          <div class="mb-3">
            <label for="networkid" class="form-label small fw-bold text-secondary">Network</label>
            <select id="networkid" name="network" class="form-select" required>
              <option value="" selected disabled>Select Network</option>
              <?php foreach($data AS $network): if($network->networkStatus=="On"): ?>
                <option value="<?php echo $network->nId;?>" 
                        networkname="<?php echo $network->network;?>" 
                        vtu="<?php echo $network->vtuStatus;?>" 
                        sharesell="<?php echo $network->sharesellStatus;?>">
                  <?php echo $network->network;?>
                </option>
              <?php endif; endforeach; ?>
            </select>
          </div>

          <!-- Type Select -->
          <div class="mb-3">
            <label for="networktype" class="form-label small fw-bold text-secondary">Type</label>
            <select id="networktype" name="networktype" class="form-select">
              <option value="VTU">VTU</option>
              <option value="Share And Sell">Share And Sell</option>
            </select>
          </div>

          <!-- Phone Input -->
          <div class="mb-3">
            <label for="phone" class="form-label small fw-bold text-secondary">Phone Number</label>
            <input type="number" id="phone" name="phone" onkeyup="verifyNetwork()" class="form-control" placeholder="Enter Phone Number" required/>
          </div>
          <p id="verifyer" class="small text-muted"></p>

          <!-- Amount -->
          <div class="mb-3">
            <label for="airtimeamount" class="form-label small fw-bold text-secondary">Amount</label>
            <input type="number" id="airtimeamount" name="amount" class="form-control" placeholder="Enter Amount" required/>
          </div>

          <!-- Amount To Pay -->
          <div class="mb-3">
            <label for="amounttopay" class="form-label small fw-bold text-secondary">Amount To Pay</label>
            <input type="number" id="amounttopay" name="amounttopay" class="form-control" placeholder="Final Amount" readonly required/>
          </div>

          <!-- Discount -->
          <div class="mb-3">
            <label for="discount" class="form-label small fw-bold text-secondary">Discount</label>
            <input type="text" id="discount" name="discount" class="form-control" placeholder="Discount %" readonly required/>
          </div>

          <!-- Validator -->
          <div class="form-check form-switch mb-3">
            <input class="form-check-input" type="checkbox" name="ported_number" id="ported_number">
            <label class="form-check-label small" for="ported_number">Disable Number Validator</label>
          </div>

          <input type="hidden" name="transref" value="<?php echo $transRef; ?>" />
          <input type="hidden" name="transkey" id="transkey" />

          <!-- Submit -->
          <button type="submit" id="airtime-btn" name="purchase-airtime" 
                  class="btn w-100 fw-bold py-2 text-white" style="background:<?php echo $sitecolor; ?>;">
            Buy Airtime
          </button>

        </fieldset>
      </form>

    </div>
  </div>
</div>
<!-- ✅ FOOTER (unified with other pages) -->
<div id="footer-bar" class="footer-bar-6-modern">
  <a href="homepage">
    <div class="icon-wrap"><ion-icon name="home-outline"></ion-icon></div>
    <span>Home</span>
  </a>
  <a href="profile">
    <div class="icon-wrap"><i class="fa fa-user"></i></div>
    <span>Profile</span>
  </a>
  <a href="contact-us">
    <div class="icon-wrap"><i class="fa fa-headset"></i></div>
    <span>Support</span>
  </a>
  <a href="transactions">
    <div class="icon-wrap"><i class="fa fa-clock-rotate-left"></i></div>
    <span>History</span>
  </a>
  <a href="more-services">
    <div class="icon-wrap"><ion-icon name="grid-outline"></ion-icon></div>
    <span>More</span>
  </a>
</div>


<!-- CSS for footer (same as other pages) -->
<style>
.footer-bar-6-modern {
  position: fixed; bottom:0; left:0; right:0;
  height:60px;
  background:#fff;
  display:flex;
  justify-content:space-around;
  align-items:center;
  border-top:1px solid #e0e0e0;
  box-shadow:0 -2px 10px rgba(0,0,0,0.08);
  z-index:9999;
}
.footer-bar-6-modern a {
  flex:1; text-align:center;
  text-decoration:none; color:#555;
  font-size:11px;
}
.footer-bar-6-modern a span {
  display:block; font-size:11px; margin-top:2px;
}
.icon-wrap {
  width:28px; height:28px;
  border-radius:50%;
  background:#f5f7fa;
  display:flex;
  align-items:center;
  justify-content:center;
  margin:0 auto 3px;
  transition:.3s;
}
.icon-wrap i, .icon-wrap ion-icon {
  font-size:16px;
  color:#1976d2;
  transition:.2s;
}
.footer-bar-6-modern a.active .icon-wrap,
.footer-bar-6-modern a:hover .icon-wrap {
  background:#1976d2;
}
.footer-bar-6-modern a.active .icon-wrap i,
.footer-bar-6-modern a.active .icon-wrap ion-icon,
.footer-bar-6-modern a:hover .icon-wrap i,
.footer-bar-6-modern a:hover .icon-wrap ion-icon {
  color:#fff;
}
</style>
