<?php
header('Content-Type: application/json');

// Include the database connection
require_once 'conn.php';

// Get the email from the POST request
$email = $_POST['email'] ?? null;

if (!$email) {
    echo json_encode(["success" => false, "message" => "Email is required."]);
    exit();
}

// Check if the email exists in the database
$sql = "SELECT sId FROM subscribers WHERE sEmail = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Generate a 6-digit verification code
    $verification_code = mt_rand(100000, 999999);
    $user = $result->fetch_assoc();
    $sId = $user['sId'];

    // Update the verification code in the database
    $update_sql = "UPDATE subscribers SET sVerCode = ? WHERE sId = ?";
    $update_stmt = $conn->prepare($update_sql);
    $update_stmt->bind_param("ii", $verification_code, $sId);

    if ($update_stmt->execute()) {
        // Send the code via email
        $subject = "Password Reset Verification Code";
        $message = "Your password reset verification code is: $verification_code";
        $headers = "From: https://smartpayplus.com.ng";

        if (mail($email, $subject, $message, $headers)) {
            echo json_encode(["success" => true, "message" => "Verification code sent to your email."]);
        } else {
            echo json_encode(["success" => false, "message" => "Failed to send email."]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Failed to generate verification code."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Email not found."]);
}

// Close connections
$stmt->close();
$conn->close();
?>