<?php
// Include the database connection file
require_once 'conn.php';

// Function to generate a 6-digit random code
function generateResetCode() {
    return rand(100000, 999999);
}

// Check if the request is valid
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);

    // Check if the email exists in the subscribers table
    $stmt = $conn->prepare("SELECT * FROM subscribers WHERE sEmail = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Generate the reset code
        $resetCode = generateResetCode();

        // Update the reset code in the subscribers table
        $updateStmt = $conn->prepare("UPDATE subscribers SET sVerCode = ? WHERE sEmail = ?");
        $updateStmt->bind_param("ss", $resetCode, $email);

        if ($updateStmt->execute()) {
            // Send the reset code via email
            $subject = "Password Reset Code";
            $message = "Your password reset code is: $resetCode";
            $headers = "From: no-reply@yourapp.com\r\n";

            if (mail($email, $subject, $message, $headers)) {
                echo json_encode(["success" => true, "message" => "Reset code sent to your email."]);
            } else {
                echo json_encode(["success" => false, "message" => "Failed to send email. Please try again."]);
            }
        } else {
            echo json_encode(["success" => false, "message" => "Failed to update reset code."]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Email not found."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request."]);
}
?>