<?php
require_once 'conn.php';
require_once 'token-fetcher.php'; // Retrieves token dynamically

ob_start(); // Start output buffering

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get data from the app
    $accountNumber = $_POST['accountNumber']; // Account number from app
    $bankCode = $_POST['bankCode'];           // Bank code from app

    // Validate input
    if (empty($accountNumber) || empty($bankCode)) {
        ob_clean(); // Clear any unwanted output
        echo "Account number and bank code are required.";
        exit;
    }

    // Verify account details
    $response = verifyAccount($conn, $accountNumber, $bankCode);

    // Send a clean response back to the app
    ob_clean(); // Clear any unwanted output
    if ($response['success']) {
        // Only output the account name on success
        echo $response['accountName'];
    } else {
        // Output error message if verification fails
        echo $response['message'];
    }
}

// Function to verify account
function verifyAccount($conn, $accountNumber, $bankCode) {
    // Fetch the valid token from the database
    $accessToken = getValidToken($conn);

    if (!$accessToken) {
        return [
            "success" => false,
            "message" => "Unable to retrieve access token."
        ];
    }

    // Monnify endpoint for account validation
    $url = "https://api.monnify.com/api/v1/disbursements/account/validate?accountNumber=$accountNumber&bankCode=$bankCode";

    // Initialize cURL
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $accessToken"
    ]);

    // Execute the request
    $response = curl_exec($ch);
    curl_close($ch);

    // Decode the response
    $result = json_decode($response, true);

    // Process the response
    if (isset($result['responseMessage']) && $result['responseMessage'] === "success") {
        return [
            "success" => true,
            "accountName" => $result['responseBody']['accountName'] // Extract account name
        ];
    } else {
        return [
            "success" => false,
            "message" => $result['responseMessage'] ?? "Failed to verify account."
        ];
    }
}

ob_end_flush(); // End output buffering and flush the buffer
?>