<?php
header('Content-Type: application/json');

// Database connection settings
$servername = "localhost";
$username = "paehdoqu_mk";        // Replace with your MySQL username
$password = "paehdoqu_mk";            // Replace with your MySQL password
$dbname = "paehdoqu_mk"; // Replace with your actual database name

// Create a connection to the MySQL database
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        'status' => 'error',
        'message' => 'Failed to connect to database: ' . $conn->connect_error
    ]));
}

// Check if the request is POST or GET and retrieve the phone number
$phoneNumber = isset($_POST['phone_number']) ? $_POST['phone_number'] : (isset($_GET['phone_number']) ? $_GET['phone_number'] : null);

if ($phoneNumber === null) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Phone number not provided'
    ]);
    exit();
}

// Query to retrieve user information based on phone_number
$sql = "SELECT balance, phone_number, last_name, first_name, account_number, email, monipoint_account, pin FROM users WHERE phone_number = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $phoneNumber); // Bind the phone number to the query
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Fetch the user data
    $userData = $result->fetch_assoc();
    
    // Prepare the response
    $response = [
        'status' => 'success',
        'user' => $userData
    ];
    
    // Send the JSON response back to the client
    echo json_encode($response);
} else {
    // If no user is found
    echo json_encode([
        'status' => 'error',
        'message' => 'User not found'
    ]);
}

// Close the connection
$stmt->close();
$conn->close();
?>