<?php
header('Content-Type: application/json');

// Include the database connection
require_once('conn.php');

// Retrieve POST data
$sFname = $_POST['sFname'];
$sLname = $_POST['sLname'];
$sPhone = $_POST['sPhone'];
$sEmail = $_POST['sEmail'];
$sState = $_POST['sState'];
$sPass = $_POST['sPass']; // Ensure this is securely hashed in PHP
$sPin = $_POST['sPin'];
$sType = $_POST['sType'];
$sWallet = $_POST['sWallet'];
$sPinStatus = $_POST['sPinStatus'];
$sRefWallet = $_POST['sRefWallet'];
$sRegStatus = $_POST['sRegStatus']; // New field

$hash = substr(sha1(md5($sPass)), 3, 10); // Simple hash for demonstration
// Automatically generate the `sApiKey`
$sApiKey = substr(str_shuffle("0123456789ABCDEFGHIJklmnopqrstvwxyzAbAcAdAeAfAgAhBaBbBcBdC1C23C3C4C5C6C7C8C9xix2x3"), 0, 60).time();

// Set the current date and time for `sRegDate`
$sRegDate = date('Y-m-d H:i:s');

// Check if the email or phone number is already registered
$sql = "SELECT * FROM subscribers WHERE sEmail = ? OR sPhone = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $sEmail, $sPhone);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Email or phone number is already registered.'
    ]);
} else {
    // Insert the new user into the `subscribers` table
    $sql = "INSERT INTO subscribers (sApiKey, sFname, sLname, sEmail, sPhone, sPass, sState, sPin, sPinStatus, sType, sWallet, sRefWallet, sRegStatus, sRegDate) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssssssssss", $sApiKey, $sFname, $sLname, $sEmail, $sPhone, $hash, $sState, $sPin, $sPinStatus, $sType, $sWallet, $sRefWallet, $sRegStatus, $sRegDate);

    if ($stmt->execute()) {
        echo json_encode([
            'success' => true,
            'message' => 'User registered successfully'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Failed to register user',
            'error' => $stmt->error // Debugging purpose
        ]);
    }
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>