<?php
header('Content-Type: application/json');

// Include the database connection file
require_once 'conn.php';

// Retrieve POST parameters
$sPhone = $_POST['sPhone'];
$sPass = $_POST['sPass'];

// Hash the password (as per your security practice)
$hash = substr(sha1(md5($sPass)), 3, 10);

// Query to check credentials
$sql = "SELECT token FROM subscribers WHERE sPhone = ? AND sPass = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $sPhone, $hash);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Fetch the user data
    $row = $result->fetch_assoc();
    $token = $row['token'];

    // If token is empty, generate a new token
    if (empty($token)) {
        $token = bin2hex(random_bytes(16)); // Generating a secure token

        // Update the token in the database
        $update_sql = "UPDATE subscribers SET token = ? WHERE sPhone = ?";
        $update_stmt = $conn->prepare($update_sql);
        $update_stmt->bind_param("ss", $token, $sPhone);
        $update_stmt->execute();
        $update_stmt->close();
    }

    // Return success response with the token
    echo json_encode(array("success" => true, "token" => $token));
} else {
    // Return failure response
    echo json_encode(array("success" => false, "message" => "Invalid phone number or password"));
}

// Close the connection
$stmt->close();
$conn->close();
?>