<?php
// Include the database connection
require_once 'conn.php';

// Query to fetch data from the electricityid table
$sql = "SELECT eId, electricityid, provider, abbreviation, providerStatus FROM electricityid";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Initialize an array to store the results
    $data = [];
    
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    
    // Return the data as JSON
    echo json_encode(["success" => true, "data" => $data]);
} else {
    // No data found
    echo json_encode(["success" => false, "message" => "No records found"]);
}

// Close the database connection
$conn->close();
?>