<?php
// Include the database connection
require_once 'conn.php';

// Get token and subscription details from your app
$token = $_POST['token'];  
$amount = $_POST['amount'];  
$cable_name = $_POST['cable_name'];  
$cable_plan = $_POST['cable_plan'];  
$smart_card_number = $_POST['smart_card_number'];
$service = "Cable Subscription"; // Specify the service type
$type = "debit"; // Specify transaction type

// Generate a random transaction ID
$transid = uniqid("trans_", true);

// Step 1: Get API details from the database
$api_query = "SELECT apikey, api_url FROM app_api WHERE service_type = 'cable' LIMIT 1";
$api_result = $conn->query($api_query);
$api_data = $api_result->fetch_assoc();
$api_url = $api_data['api_url'];
$api_key = $api_data['apikey'];

// Step 2: Check user balance and retrieve username
$user_query = "SELECT bal, username FROM user WHERE token = '$token'";
$user_result = $conn->query($user_query);

if ($user_result->num_rows > 0) {
    $user_data = $user_result->fetch_assoc();
    $user_balance = $user_data['bal'];
    $username = $user_data['username'];

    // Store the old balance for logging
    $old_balance = $user_balance;

    // Step 3: Verify balance is sufficient
    if ($user_balance >= $amount) {
        
        // Prepare API request payload
        $payload = array(
            'cablename' => $cable_name,
            'cableplan' => $cable_plan,
            'smart_card_number' => $smart_card_number
        );

        $options = array(
            'http' => array(
                'header'  => "Content-Type: application/json\r\n" .
                             "Authorization: Token $api_key\r\n",
                'method'  => 'POST',
                'content' => json_encode($payload)
            )
        );
        $context  = stream_context_create($options);
        
        // Execute the API request with error handling
        $result = @file_get_contents($api_url, false, $context);
        if ($result === FALSE) {
            echo json_encode(array("success" => false, "message" => "Failed to connect to the API."));
            exit();
        }

        // Decode the API response
        $response = json_decode($result, true);

        // Check if the transaction was successful
        if (isset($response['success']) && $response['success'] === true) {
            // Deduct balance and update user balance in database
            $new_balance = $user_balance - $amount;
            $update_balance_query = "UPDATE user SET bal = '$new_balance' WHERE token = '$token'";
            if ($conn->query($update_balance_query) === TRUE) {
                
                // Insert transaction record with status "success"
                $status = 1; // Use "1" for successful transactions
                $timestamp = date("Y-m-d H:i:s");
                $transaction_query = "INSERT INTO transactions (username, transid, network, mobile, service, plans, type, amount, status, date, oldbal, newbal) 
                                      VALUES ('$username', '$transid', '$cable_name', '$smart_card_number', '$service', '$cable_plan', '$type', '$amount', '$status', '$timestamp', '$old_balance', '$new_balance')";
                $conn->query($transaction_query);

                // Return success response
                echo json_encode(array("success" => true, "message" => "Cable subscription successful."));
            } else {
                echo json_encode(array("success" => false, "message" => "Failed to update balance."));
            }
        } else {
            // Transaction failed, log only if there's a failure other than insufficient balance or unavailability
            $status = 0; // Use "0" for failed transactions
            $timestamp = date("Y-m-d H:i:s");
            $transaction_query = "INSERT INTO transactions (username, transid, network, mobile, service, plans, type, amount, status, date, oldbal, newbal) 
                                  VALUES ('$username', '$transid', '$cable_name', '$smart_card_number', '$service', '$cable_plan', '$type', '$amount', '$status', '$timestamp', '$old_balance', '$old_balance')";
            $conn->query($transaction_query);

            // Return failure message
            echo json_encode(array("success" => false, "message" => $response['message'] ?? "Service temporarily unavailable."));
        }
    } else {
        // Return insufficient balance message without logging
        echo json_encode(array("success" => false, "message" => "Insufficient balance."));
    }
} else {
    echo json_encode(array("success" => false, "message" => "User not found."));
}

// Close connection
$conn->close();
?>