<?php
// Include the database connection
require_once 'conn.php';

// Get token and data package details from the app
$token = $_POST['token'];
$mobile_number = $_POST['phone'];
$network_id = $_POST['network'];
$plan_id = $_POST['data_plan'];
$ported_number = $_POST['ported_number'];
$request_id = $_POST['request-id'];
$service = "Data Purchase";

// Step 1: Get API details from the database
$api_query = "SELECT apikey, apilink FROM api2 WHERE value = 'data'";
$api_result = $conn->query($api_query);
$api_data = $api_result->fetch_assoc();
$apilink = $api_data['apilink'];
$apikey = $api_data['apikey'];

// Step 2: Check user balance and retrieve user details
$user_query = "SELECT sWallet, sId, sType FROM subscribers WHERE token = '$token'";
$user_result = $conn->query($user_query);

if ($user_result->num_rows > 0) {
    $user_data = $user_result->fetch_assoc();
    $user_balance = $user_data['sWallet'];
    $sId = $user_data['sId'];
    $sType = $user_data['sType'];
    $old_balance = $user_balance;

    // Step 3: Fetch API price and selling price
    $plan_query = "SELECT price, userprice, agentprice, vendorprice FROM dataplans WHERE planid = '$plan_id'";
    $plan_result = $conn->query($plan_query);

    if ($plan_result->num_rows > 0) {
        $plan_data = $plan_result->fetch_assoc();
        $api_price = $plan_data['price'];

        // Determine selling price based on user type
        $selling_price = ($sType == 1) ? $plan_data['userprice'] :
                         (($sType == 2) ? $plan_data['agentprice'] : $plan_data['vendorprice']);

        // Calculate profit
        $profit = $selling_price - $api_price;

        // Step 4: Verify balance is sufficient
        if ($user_balance >= $selling_price) {
            
            // Use different payloads based on API link
            if (in_array($apilink, ["https://nabatulusub.com/api/data/", "https://legitdataway.com/api/data/", "https://n3tdata247.com/api/data/"])) {
                $payload = array(
                    'network' => $network_id,
                    'phone' => $mobile_number,
                    'data_plan' => $plan_id,
                    'bypass' => false,
                    'request-id' => $request_id
                );
            } else {
                $payload = array(
                    'network' => $network_id,
                    'mobile_number' => $mobile_number,
                    'plan' => $plan_id,
                    'Ported_number' => filter_var($ported_number, FILTER_VALIDATE_BOOLEAN)
                );
            }

            // Initialize cURL
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $apilink);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $headers = [
                "Authorization: Token $apikey",
                "Content-Type: application/json"
            ];
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $result = curl_exec($ch);
            $error = curl_error($ch);
            curl_close($ch);

            if ($error) {
                echo json_encode(["success" => false, "message" => "Failed to connect to the API: $error"]);
                exit();
            }

            // Decode the API response
            $response = json_decode($result, true);

            // Check if transaction was successful
            if (isset($response['status']) && 
               (strtolower($response['status']) === "successful" || 
                strtolower($response['Status']) === "successful" || 
                strtolower($response['status']) === "success")) {

                $new_balance = $user_balance - $selling_price;
                $update_balance_query = "UPDATE subscribers SET sWallet = '$new_balance' WHERE token = '$token'";

                if ($conn->query($update_balance_query) === TRUE) {
                    $status = 0;
                    $timestamp = date("Y-m-d H:i:s");

                    // Save transaction
                    $transaction_query = "INSERT INTO transactions (sId, transref, servicename, servicedesc, amount, status, oldbal, newbal, profit, date) 
                                          VALUES ('$sId', '$request_id', '$service', 'Data Purchase for $mobile_number', '$selling_price', '$status', '$old_balance', '$new_balance', '$profit', '$timestamp')";
                    $conn->query($transaction_query);

                    // Send actual API response message
                    echo json_encode([
                        "success" => true,
                        "message" => $response['message'] ?? "Data purchase successful",
                        "api_response" => $response
                    ]);
                    exit();
                } else {
                    echo json_encode(["success" => false, "message" => "Data purchase successful, but balance update failed."]);
                    exit();
                }
            } else {
                // Return actual API error message
                echo json_encode([
                    "success" => false,
                    "message" => $response['message'] ?? "Transaction failed.",
                    "api_response" => $response
                ]);
                exit();
            }
        } else {
            echo json_encode(["success" => false, "message" => "Insufficient balance."]);
            exit();
        }
    } else {
        echo json_encode(["success" => false, "message" => "Data plan not found."]);
        exit();
    }
} else {
    echo json_encode(["success" => false, "message" => "User not found."]);
    exit();
}

$conn->close();
?>