<?php
// Database connection
$conn = new mysqli('localhost', 'username', 'password', 'database');
if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

// Fetch requests
$sql = "SELECT * FROM sell_pi_requests ORDER BY created_at DESC";
$result = $conn->query($sql);
$piRequests = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $piRequests[] = $row;
    }
}

$conn->close();
?>
<div class="row">
<div class="col-12">
    <div class="box">
        <div class="box-header with-border d-flex align-items-center justify-content-between">
            <h4 class="box-title">Pi Selling Requests</h4>
        </div>
        <div class="box-body">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>User Details</th>
                    <th>Pi Amount</th>
                    <th>Bank Details</th>
                    <th>Transaction Receipt</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($piRequests as $key => $request): ?>
                <tr>
                    <td><?php echo $key + 1; ?></td>
                    <td>
                        <p>Name: <?php echo $request['receiver_name']; ?></p>
                        <p>WhatsApp: <?php echo $request['whatsapp']; ?></p>
                    </td>
                    <td><?php echo $request['amount_sell']; ?> Pi</td>
                    <td>
                        <p>Bank: <?php echo $request['bank_name']; ?></p>
                        <p>Account: <?php echo $request['bank_account']; ?></p>
                    </td>
                    <td>
                        <a href="<?php echo $request['transaction_receipt']; ?>" target="_blank">View Receipt</a>
                    </td>
                    <td><?php echo $request['status']; ?></td>
                    <td>
                        <button class="btn btn-success" onclick="approveRequest(<?php echo $request['id']; ?>)">Approve</button>
                        <button class="btn btn-danger" onclick="rejectRequest(<?php echo $request['id']; ?>)">Reject</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>
    </div>
</div>
</div>

<script>
function approveRequest(id) {
    if (confirm("Approve this request?")) {
        window.location.href = "approve_request.php?id=" + id;
    }
}

function rejectRequest(id) {
    if (confirm("Reject this request?")) {
        window.location.href = "reject_request.php?id=" + id;
    }
}
</script>