<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Notification Manager</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../assets/styles/bootstrap.css">
  <link rel="stylesheet" href="../assets/styles/style.css">
  <link rel="stylesheet" href="../assets/fonts/css/fontawesome-all.min.css">
  <style>
    body { font-family: 'Poppins', sans-serif; background: #f4f9ff; }
    .popup-notify {
      position: fixed;
      top: 20px;
      left: 50%;
      transform: translateX(-50%);
      background: #1976d2;
      color: #fff;
      padding: 12px 20px;
      border-radius: 30px;
      font-size: 16px;
      font-weight: 500;
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
      z-index: 9999;
      display: none;
      white-space: pre-wrap;
      word-break: break-word;
      max-width: 90%;
      text-align: center;
      animation: fadeInOut 4s ease forwards;
    }
    @keyframes fadeInOut {
      0% { opacity: 0; transform: translateY(-10px); }
      10% { opacity: 1; transform: translateY(0); }
      90% { opacity: 1; }
      100% { opacity: 0; transform: translateY(-10px); }
    }
  </style>
</head>
<body>

<div class="container mt-4">
  <div class="row">
    <!-- Notification Status -->
    <div class="col-12 mb-4">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Set Notification</h5>
          <form method="post">
            <div class="form-group">
              <label>Notification Status</label>
              <select name="notificationstatus" class="form-control" required>
                <?php if($data[0]->notificationStatus == "On"): ?>
                  <option value="On" selected>Enable</option>
                  <option value="Off">Disable</option>
                <?php else: ?>
                  <option value="On">Enable</option>
                  <option value="Off" selected>Disable</option>
                <?php endif; ?>
              </select>
            </div>
            <button type="submit" name="update-notification-status" class="btn btn-primary mt-2">
              <i class="fa fa-save"></i> Update Status
            </button>
          </form>
        </div>
      </div>
    </div>

    <!-- Notification Table -->
    <div class="col-12 mb-4">
      <div class="card">
        <div class="card-body">
          <a class="btn btn-success text-white mb-3" data-toggle="modal" data-target="#addNotification">
            <i class="fa fa-plus"></i> Add New
          </a>
          <h5 class="card-title">All Notifications</h5>
          <table class="table table-borderedless">
            <thead>
              <tr>
                <th>#</th>
                <th>Subject</th>
                <th>For</th>
                <th>Message</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php $cnt=1; $results=$data[1];
              if($results && $results != 1){
                foreach($results as $result){ ?>
                  <tr>
                    <td><?php echo $cnt++; ?></td>
                    <td><?php echo htmlspecialchars($result->subject, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); ?></td>
                    <td>
                      <?php echo ($result->msgfor == 3 ? "General" : ($result->msgfor == 1 ? "Subscribers" : "Agent")); ?>
                    </td>
                    <td><?php echo htmlspecialchars($result->message, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); ?></td>
                    <td>
                      <a href="#" onclick="deleteNotification(<?php echo $result->msgId; ?>)" class="btn btn-danger">
                        <i class="fa fa-trash"></i>
                      </a>
                    </td>
                  </tr>
                  <script>
                    showPopup(<?php echo json_encode($result->message, JSON_UNESCAPED_UNICODE); ?>);
                  </script>
              <?php }} ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Add Notification Modal -->
<div class="modal fade" id="addNotification" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content border">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Add New Notification</h5>
      </div>
      <div class="modal-body">
        <form method="post" enctype="multipart/form-data">
          <div class="form-group">
            <label>Subject</label>
            <input type="text" name="subject" class="form-control" required placeholder="Subject">
          </div>
          <div class="form-group">
            <label>Message For</label>
            <select name="msgfor" class="form-control" required>
              <option value="3">General</option>
              <option value="1">Subscribers</option>
              <option value="2">Agent</option>
            </select>
          </div>
          <div class="form-group">
            <label>Upload Image</label>
            <input type="file" name="image" class="form-control">
          </div>
          <div class="form-group">
            <label>Message</label>
            <textarea name="message" rows="4" class="form-control" required placeholder="Message (emoji supported 😊🔥✅)"></textarea>
          </div>
          <div class="d-flex justify-content-between">
            <button type="submit" name="add-notification" class="btn btn-primary">
              <i class="fa fa-plus"></i> Add Notification
            </button>
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Popup Container -->
<div id="popupNotify" class="popup-notify"></div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function showPopup(message){
  const popup = document.getElementById('popupNotify');
  popup.innerHTML = message;
  popup.style.display = 'block';
  setTimeout(() => popup.style.display = 'none', 4000);
}
function deleteNotification(id){
  if(confirm("Are you sure you want to delete this notification?")){
    // Add your AJAX delete logic here
    alert("Deleted ID: " + id);
  }
}
</script>
</body>
</html>


