<div class="row g-4">

  <!-- Wallet Stats -->
  <?php
    $walletStats = [
      ["label" => "User Wallet", "value" => $data[0]["uwCount"], "icon" => "fa-user", "color" => "primary"],
      ["label" => "Agent Wallet", "value" => $data[0]["awCount"], "icon" => "fa-user-tie", "color" => "info"],
      ["label" => "Vendor Wallet", "value" => $data[0]["vwCount"], "icon" => "fa-store", "color" => "warning"],
      ["label" => "Referral Wallet", "value" => $data[0]["rwCount"], "icon" => "fa-users", "color" => "success"]
    ];
    foreach($walletStats as $stat):
  ?>
  <div class="col-md-3">
    <div class="card shadow-sm border-0">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <h5 class="mb-1 text-<?php echo $stat["color"]; ?>"><?php echo $stat["label"]; ?></h5>
          <h3 class="fw-bold">₦<?php echo number_format($stat["value"]); ?></h3>
        </div>
        <i class="fa <?php echo $stat["icon"]; ?> text-<?php echo $stat["color"]; ?> fa-2x"></i>
      </div>
    </div>
  </div>
  <?php endforeach; ?>

  <!-- User Counts -->
  <?php
    $userStats = [
      ["label" => "Subscribers", "value" => $data[0]["sCount"], "icon" => "fa-user", "color" => "primary"],
      ["label" => "Agents", "value" => $data[0]["aCount"], "icon" => "fa-user-tie", "color" => "info"],
      ["label" => "Vendors", "value" => $data[0]["vCount"], "icon" => "fa-store", "color" => "warning"],
      ["label" => "Referrals", "value" => $data[0]["rCount"], "icon" => "fa-users", "color" => "success"]
    ];
    foreach($userStats as $stat):
  ?>
  <div class="col-md-3">
    <div class="card shadow-sm border-0">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <h5 class="mb-1"><?php echo $stat["label"]; ?></h5>
          <h3 class="fw-bold"><?php echo $stat["value"]; ?></h3>
        </div>
        <i class="fa <?php echo $stat["icon"]; ?> text-<?php echo $stat["color"]; ?> fa-2x"></i>
      </div>
    </div>
  </div>
  <?php endforeach; ?>

  <!-- Traffic & System Stats -->
  <?php
    $systemStats = [
      ["label" => "Transactions", "value" => $data[0]["tCount"], "icon" => "fa-list-alt", "color" => "danger"],
      ["label" => "Unread Messages", "value" => $data[0]["mCount"], "icon" => "fa-envelope", "color" => "danger"],
      ["label" => "Visits Today", "value" => $data[0]["visitCount"], "icon" => "fa-eye", "color" => "danger"]
    ];
    foreach($systemStats as $stat):
  ?>
  <div class="col-md-4">
    <div class="card shadow-sm border-0">
      <div class="card-body d-flex align-items-center justify-content-between">
        <div>
          <h5 class="mb-1"><?php echo $stat["label"]; ?></h5>
          <h3 class="fw-bold"><?php echo $stat["value"]; ?></h3>
        </div>
        <i class="fa <?php echo $stat["icon"]; ?> text-<?php echo $stat["color"]; ?> fa-2x"></i>
      </div>
    </div>
  </div>
  <?php endforeach; ?>

</div>
