<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
  <meta name="description" content="LILB-DATA Delete Account Policy - Learn how to request deletion of your account and data from our VTU app for Nigeria.">
  <title>LILB-DATA - Delete Account Policy</title>
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;600&display=swap" rel="stylesheet">
  <!-- Font Awesome for Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <style>
  /* CSS Reset */
  *, *::before, *::after {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
  }

  body {
    font-family: 'Poppins', sans-serif, Arial, sans-serif;
    line-height: 1.6;
    background-color: #f4f8fc; /* very light blue/white background */
    overflow-x: hidden;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  /* Navbar */
  .navbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: clamp(10px, 2vw, 15px) clamp(15px, 3vw, 20px);
    background-color: #ffffff;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    position: sticky;
    top: 0;
    z-index: 1000;
  }

  .navbar .logo img {
    width: clamp(40px, 5vw, 50px);
  }

  .nav-links {
    display: flex;
    gap: clamp(10px, 2vw, 20px);
  }

  .nav-links a {
    text-decoration: none;
    color: #0056b3;   /* deep blue */
    font-weight: 600;
    font-size: clamp(14px, 1.8vw, 16px);
    transition: color 0.3s ease;
  }

  .nav-links a:hover {
    color: #007bff;   /* bright blue */
  }

  .menu-toggle {
    display: none;
    font-size: clamp(20px, 3vw, 24px);
    cursor: pointer;
    color: #0056b3;
  }

  /* Hero Section */
  .hero {
    min-height: 50vh;
    background: linear-gradient(135deg, #007bff, #0056b3); /* blue gradient */
    color: #ffffff;
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    padding: clamp(40px, 10vh, 80px) clamp(15px, 3vw, 20px);
  }

  .hero-content h1 {
    font-size: clamp(2rem, 5vw, 3rem);
    margin-bottom: clamp(15px, 2vh, 20px);
    animation: fadeIn 1s ease-in;
  }

  .hero-content p {
    font-size: clamp(1rem, 2.5vw, 1.2rem);
    max-width: 600px;
    margin: 0 auto;
    animation: fadeIn 1.2s ease-in;
  }

  /* Content */
  .delete-account-policy {
    padding: clamp(40px, 8vh, 60px) clamp(15px, 3vw, 20px);
    background-color: #ffffff;
    max-width: 1200px;
    margin: 0 auto;
    text-align: left;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
  }

  .delete-account-policy h2 {
    font-size: clamp(1.8rem, 4vw, 2.5rem);
    color: #0056b3;
    margin-bottom: clamp(20px, 4vh, 30px);
    text-align: center;
  }

  .delete-account-policy h3 {
    font-size: clamp(1.2rem, 2.5vw, 1.5rem);
    color: #007bff;
    margin: clamp(15px, 2vh, 20px) 0 clamp(10px, 1.5vh, 15px);
  }

  .delete-account-policy p,
  .delete-account-policy ul {
    font-size: clamp(0.9rem, 1.8vw, 1rem);
    color: #333;
    margin-bottom: clamp(10px, 2vh, 15px);
    line-height: 1.8;
  }

  .delete-account-policy ul {
    list-style: disc;
    padding-left: clamp(20px, 3vw, 30px);
  }

  .delete-account-policy a {
    color: #007bff;
    text-decoration: none;
  }

  .delete-account-policy a:hover {
    text-decoration: underline;
  }

  /* Footer */
  .footer {
    padding: clamp(30px, 6vh, 40px) clamp(15px, 3vw, 20px);
    background-color: #0056b3;
    color: #ffffff;
    text-align: center;
  }

  .footer a {
    color: #ffffff;
    text-decoration: none;
    margin: 0 clamp(8px, 1.5vw, 10px);
    font-size: clamp(0.9rem, 1.8vw, 1rem);
    transition: color 0.3s ease;
  }

  .footer a:hover {
    color: #cce0ff; /* lighter hover blue */
  }

  .footer p {
    margin-top: clamp(15px, 2vh, 20px);
    font-size: clamp(0.8rem, 1.5vw, 0.9rem);
  }

  .social-icons {
    margin: clamp(10px, 2vh, 15px) 0;
  }

  .social-icons a {
    font-size: clamp(1.2rem, 2.5vw, 1.5rem);
    margin: 0 clamp(5px, 1vw, 8px);
    color: #ffffff;
    transition: color 0.3s ease;
  }

  .social-icons a:hover {
    color: #cce0ff;
  }

  /* Animations */
  @keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
  }

  .fade-in {
    opacity: 0;
    transition: opacity 0.8s ease-in;
  }

  .fade-in.visible {
    opacity: 1;
  }

  /* Mobile */
  @media (max-width: 768px) {
    .menu-toggle { display: block; }
    .nav-links {
      display: none;
      position: absolute;
      top: clamp(50px, 10vh, 60px);
      left: 0;
      width: 100%;
      background-color: #ffffff;
      padding: clamp(15px, 3vh, 20px);
      flex-direction: column;
      text-align: center;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
      z-index: 999;
    }
    .nav-links.active { display: flex; }
    .nav-links a { margin: clamp(8px, 1.5vh, 10px) 0; font-size: clamp(16px, 3vw, 18px); }
  }
</style>
</head>
<body>
  <!-- Navbar -->
  <nav class="navbar">
    <div class="menu-toggle">
      <i class="fas fa-bars"></i>
    </div>
    <div class="nav-links">
      <a href="index.html#home">Home</a>
      <a href="https://LILB-DATA.com.ng/mobile">Login</a>
      <a href="https://LILB-DATA.com.ng/mobile/register">Register</a>
    </div>
  </nav>

  <!-- Hero Section -->
  <section id="home" class="hero">
    <div class="hero-content">
      <h1>Delete Account Policy</h1>
      <p>Learn how to request the deletion of your LILB-DATA account and personal data.</p>
    </div>
  </section>

  <!-- Delete Account Policy Content -->
  <section class="delete-account-policy fade-in">
    <h2>LILB-DATA Delete Account Policy</h2>
    <p>Last Updated: June 25, 2025</p>

    <h3>1. Introduction</h3>
    <p>At LILB-DATA, we respect your right to control your personal data. This Delete Account Policy outlines the process for requesting the deletion of your account and associated data from our Virtual Top-Up (VTU) application for airtime, data, and bill payments in Nigeria. As our app requires users to create an account and log in, we provide a clear mechanism for account deletion in compliance with the Nigeria Data Protection Regulation (NDPR).</p>

    <h3>2. Who Can Request Deletion</h3>
    <p>Only registered users aged 18 and older who have an active LILB-DATA account can request account deletion. We do not knowingly collect data from users under 18, and such accounts, if discovered, are terminated immediately.</p>

    <h3>3. How to Request Account Deletion</h3>
    <p>To delete your LILB-DATA account and all associated personal data, please follow these steps:</p>
    <ul>
      <li>Send an email to <a href="mailto:info@LILB-DATA.com.ng">info@LILB-DATA.com.ng</a>.</li>
      <li>Use the subject line: <strong>"I want to delete my data"</strong>.</li>
      <li>Include the following information in your email:
        <ul>
          <li>Full Name (as registered in the app)</li>
          <li>Phone Number (associated with your account)</li>
          <li>Email Address (associated with your account)</li>
        </ul>
      </li>
      <li>Submit the email from the email address linked to your LILB-DATA account.</li>
    </ul>
    <p>We may contact you to verify your identity to ensure the request is legitimate.</p>

    <h3>4. What Data Will Be Deleted</h3>
    <p>Upon successful verification, we will delete all personal data associated with your account, including:</p>
    <ul>
      <li>Account Information: Name, phone number, email address, and password.</li>
      <li>Transaction Data: Records of airtime top-ups, data purchases, and bill payments.</li>
      <li>Device Information: Device type, operating system, IP address, and unique identifiers.</li>
      <li>Usage Data: Information on how you interacted with the app.</li>
    </ul>
    <p>Note: Certain data may be retained if required by law (e.g., transaction records for tax or audit purposes), but it will be anonymized to prevent identification.</p>

    <h3>5. Processing Time</h3>
    <p>We will process your deletion request within 2 days of receiving and verifying your email. You will receive a confirmation email once your account and data have been deleted. If we are unable to verify your identity, we will notify you to provide additional information.</p>

    <h3>6. Data Security</h3>
    <p>Your data is protected with industry-standard encryption and security measures during the deletion process. We do not share, sell, or disclose your data to third parties, except as required by law (e.g., court orders).</p>

    <h3>7. Impact of Deletion</h3>
    <p>Once your account is deleted:</p>
    <ul>
      <li>You will lose access to the LILB-DATA app and its services.</li>
      <li>All transaction history and preferences will be removed (except legally required data).</li>
      <li>You will need to create a new account to use LILB-DATA again in the future.</li>
    </ul>

    <h3>8. Your Rights</h3>
    <p>Under the NDPR, you have the right to:</p>
    <ul>
      <li>Request deletion of your personal data.</li>
      <li>Access or correct your data before deletion.</li>
      <li>Lodge a complaint with the National Information Technology Development Agency (NITDA).</li>
    </ul>
    <p>Contact us at <a href="mailto:info@LILB-DATA.com.ng">info@LILB-DATA.com.ng</a> to exercise these rights.</p>

    <h3>9. Contact Us</h3>
    <p>For questions or assistance with account deletion, please contact:</p>
    <ul>
      
  </section>

  <!-- Footer -->
  <footer class="footer">
    <div>
      <a href="mailto:info@LILB-DATA.com.ng">Contact Us</a>
      <a href="privacy-policy.html">Privacy Policy</a>
      <a href="Delete-Account-Policy.php">Delete Account Policy</a>
    </div>
    <div class="social-icons">
      <a href="#"><i class="fab fa-facebook-f"></i></a>
      <a href="#"><i class="fab fa-twitter"></i></a>
      <a href="#"><i class="fab fa-instagram"></i></a>
    </div>
    <p>Developed by GCUBED International.</p>
  </footer>

  <!-- JavaScript -->
  <script>
    // Menu Toggle for Mobile
    const menuToggle = document.querySelector('.menu-toggle');
    const navLinks = document.querySelector('.nav-links');

    menuToggle.addEventListener('click', () => {
      navLinks.classList.toggle('active');
      menuToggle.innerHTML = navLinks.classList.contains('active') ? '<i class="fas fa-times"></i>' : '<i class="fas fa-bars"></i>';
    });

    // Smooth Scrolling
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
      anchor.addEventListener('click', function(e) {
        e.preventDefault();
        document.querySelector(this.getAttribute('href')).scrollIntoView({
          behavior: 'smooth'
        });
        navLinks.classList.remove('active');
        menuToggle.innerHTML = '<i class="fas fa-bars"></i>';
      });
    });

    // Fade-in Animation with Fallback
    if ('IntersectionObserver' in window) {
      const fadeElements = document.querySelectorAll('.fade-in');
      const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            entry.target.classList.add('visible');
            observer.unobserve(entry.target);
          }
        });
      }, { threshold: 0.1 });

      fadeElements.forEach(element => observer.observe(element));
    } else {
      // Fallback for older browsers
      document.querySelectorAll('.fade-in').forEach(element => {
        element.classList.add('visible');
      });
    }
  </script>
</body>
</html>